/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import org.infinispan.rest.ALPNHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;

public class RestChannelInitializer
extends NettyChannelInitializer {
    static final int MAX_INITIAL_LINE_SIZE = 4096;
    static final int MAX_HEADER_SIZE = 8192;
    private final ALPNHandler alpnHandler;
    private final RestServer restServer;

    public RestChannelInitializer(RestServer restServer, NettyTransport transport) {
        super((ProtocolServer)restServer, transport, null, null);
        this.restServer = restServer;
        this.alpnHandler = new ALPNHandler(restServer);
    }

    public void initializeChannel(Channel ch) throws Exception {
        super.initializeChannel(ch);
        if (this.server.getConfiguration().ssl().enabled()) {
            this.configureSSL(ch);
        } else {
            this.alpnHandler.configurePipeline(ch.pipeline(), "http/1.1");
        }
    }

    private void configureSSL(Channel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{this.alpnHandler});
    }

    protected int maxContentLength() {
        return ((RestServerConfiguration)this.restServer.getConfiguration()).maxContentLength() + 4096 + 8192;
    }

    protected ApplicationProtocolConfig getAlpnConfiguration() {
        return this.alpnHandler.getAlpnConfiguration();
    }

    public ALPNHandler getAlpnHandler() {
        return this.alpnHandler;
    }
}

