/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6127)
public class JsonSetFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, String> {
    public static final String ERR_VALUE_CAN_T_BE_NULL = "value can't be null";
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    @ProtoField(value=1)
    final byte[] value;
    @ProtoField(value=2)
    final byte[] path;
    @ProtoField(value=3)
    final boolean nx;
    @ProtoField(value=4)
    final boolean xx;

    @ProtoFactory
    public JsonSetFunction(byte[] value, byte[] path, boolean nx, boolean xx) {
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.value = value;
        this.path = path;
        this.nx = nx;
        this.xx = xx;
    }

    public String apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonNode newNode;
        try {
            newNode = JSONUtil.objectMapper.readTree(this.value);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        JsonBucket doc = entryView.find().orElse(null);
        byte[] jsonPath = JSONUtil.toJsonPath(this.path);
        if (doc == null) {
            if (this.xx) {
                return null;
            }
            if (!JSONUtil.isRoot(jsonPath)) {
                throw new CacheException("new objects must be created at root");
            }
            entryView.set((Object)new JsonBucket(this.value), new MetaParam.Writable[0]);
            return "OK";
        }
        if (JSONUtil.isRoot(jsonPath)) {
            if (this.nx) {
                return null;
            }
            entryView.set((Object)new JsonBucket(this.value), new MetaParam.Writable[0]);
            return "OK";
        }
        try {
            Object resObj;
            JsonNode rootObjectNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForSet.parse((Object)rootObjectNode);
            String pathStr = new String(jsonPath, StandardCharsets.UTF_8);
            JsonNode node = (JsonNode)jpCtx.read(pathStr, new Predicate[0]);
            if ((node == null || node.isNull()) && this.xx || node != null && !node.isNull() && this.nx) {
                return null;
            }
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            if (jpath.isDefinite()) {
                resObj = jpath.set(jpCtx.json(), (Object)newNode, JSONUtil.configForDefiniteSet);
            } else {
                resObj = jpath.set(jpCtx.json(), (Object)newNode, JSONUtil.configForSet);
                if (((JsonNode)resObj).isEmpty()) {
                    throw new CacheException("Wrong static path");
                }
            }
            if (resObj != null) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootObjectNode)), new MetaParam.Writable[0]);
                return "OK";
            }
            return null;
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

