/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import org.infinispan.server.resp.json.InfinispanJacksonArrayNode;

public class InfinispanJacksonJsonNodeProvider
extends JacksonJsonNodeJsonProvider {
    public InfinispanJacksonJsonNodeProvider() {
    }

    public InfinispanJacksonJsonNodeProvider(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove(key.toString());
        } else {
            int effectiveIndex;
            ArrayNode array = this.toJsonArray(obj);
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            int n = effectiveIndex = index >= 0 ? index : array.size() + index;
            if (effectiveIndex >= 0 && effectiveIndex < array.size()) {
                array.remove(effectiveIndex);
            } else {
                throw new IndexOutOfBoundsException("Illegal index " + index + ", array size " + array.size());
            }
        }
    }

    public void setArrayIndex(Object array, int index, Object newValue) {
        int effectiveIndex;
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        ArrayNode arrayNode = this.toJsonArray(array);
        int n = effectiveIndex = index >= 0 ? index : arrayNode.size() + index;
        if (array instanceof InfinispanJacksonArrayNode) {
            if (effectiveIndex >= arrayNode.size() || effectiveIndex < 0) {
                throw new UnsupportedOperationException("array index out of range");
            }
            arrayNode.set(effectiveIndex, this.createJsonElement(newValue));
        } else {
            super.setArrayIndex(array, effectiveIndex, newValue);
        }
    }

    private JsonNode createJsonElement(Object o) {
        if (o != null) {
            return o instanceof JsonNode ? (JsonNode)o : this.objectMapper.valueToTree(o);
        }
        return null;
    }

    private ArrayNode toJsonArray(Object o) {
        return (ArrayNode)o;
    }

    private ObjectNode toJsonObject(Object o) {
        return (ObjectNode)o;
    }
}

