/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.json;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.json.JSONCommandArgumentReader;
import org.infinispan.server.resp.json.EmbeddedJsonCache;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class JSONRESP
extends RespCommand
implements Resp3Command {
    public JSONRESP() {
        super("JSON.RESP", -2, 1, 1, 1, AclCategory.JSON.mask() | AclCategory.READ.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        JSONCommandArgumentReader.CommandArgs commandArgs = JSONCommandArgumentReader.readCommandArgs(arguments);
        EmbeddedJsonCache ejc = handler.getJsonCache();
        CompletionStage<List<Object>> result = ejc.resp(commandArgs.key(), commandArgs.jsonPath());
        return handler.stageToReturn(result, ctx, new JsonRespResponseSerializer(commandArgs));
    }

    private static class JsonRespResponseSerializer
    implements JavaObjectSerializer<List<Object>> {
        private final boolean isLegacy;
        private final String jsonPath;

        public JsonRespResponseSerializer(JSONCommandArgumentReader.CommandArgs commandArgs) {
            this.isLegacy = commandArgs.isLegacy();
            this.jsonPath = RespUtil.utf8(commandArgs.jsonPath());
        }

        @Override
        public void accept(List<Object> list, ResponseWriter writer) {
            if (list == null) {
                writer.nulls();
                return;
            }
            if (this.isLegacy) {
                if (list.isEmpty()) {
                    writer.error("-ERR Path '" + this.jsonPath + "' does not exist");
                    return;
                }
                this.writeNode(list.get(0), writer);
                return;
            }
            this.writeNode(list, writer);
        }

        private void writeNode(Object object, ResponseWriter writer) {
            if (object == null) {
                writer.nulls();
                return;
            }
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                writer.integers(i);
                return;
            }
            if (object instanceof Long) {
                Long l = (Long)object;
                writer.integers(l);
                return;
            }
            if (object instanceof Double) {
                Double d = (Double)object;
                writer.doubles(d);
                return;
            }
            if (object instanceof Character) {
                Character c = (Character)object;
                writer.simpleString(c.toString());
                return;
            }
            if (object instanceof String) {
                String s = (String)object;
                writer.string(s);
                return;
            }
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                writer.simpleString(b != false ? "true" : "false");
                return;
            }
            if (object instanceof List) {
                List list = (List)object;
                writer.writeNumericPrefix((byte)42, list.size());
                for (Object node : list) {
                    this.writeNode(node, writer);
                }
            }
        }
    }
}

