/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.json;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.json.EmbeddedJsonCache;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class JSONMGET
extends RespCommand
implements Resp3Command {
    public JSONMGET() {
        super("JSON.MGET", -3, 1, -1, 1, AclCategory.JSON.mask() | AclCategory.READ.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        List<byte[]> keys = arguments.subList(0, arguments.size() - 1);
        List<byte[]> paths = arguments.subList(arguments.size() - 1, arguments.size());
        EmbeddedJsonCache ejc = handler.getJsonCache();
        CompletionStage results = CompletionStages.performSequentially(keys.iterator(), k -> ejc.get((byte[])k, paths, null, null, null).exceptionally(JSONMGET::handleWrongTypeError), Collectors.toList());
        return handler.stageToReturn(results, ctx, ResponseWriter.ARRAY_BULK_STRING);
    }

    private static byte[] handleWrongTypeError(Throwable ex) {
        if (RespUtil.isWrongTypeError(ex)) {
            return null;
        }
        if (ex.getCause() instanceof NoSuchElementException && ex.getCause().getMessage() != null && ex.getCause().getMessage().contains("does not exist")) {
            return null;
        }
        throw CompletableFutures.asCompletionException((Throwable)ex);
    }
}

