/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.logging;

import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.infinispan.commons.util.Util;
import org.infinispan.server.resp.logging.AccessData;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public class RespAccessLogger {
    public static final Logger log = LogFactory.getLogger((String)"RESP_ACCESS_LOG");

    public static boolean isEnabled() {
        return log.isTraceEnabled();
    }

    static void success(ChannelFuture future, AccessData data) {
        RespAccessLogger.log(future, data, "OK");
    }

    static void failure(ChannelFuture future, AccessData data, Throwable throwable) {
        RespAccessLogger.log(future, data, "\"" + throwable.getMessage() + "\"");
    }

    private static void log(ChannelFuture future, AccessData data, String status) {
        String remoteAddress = ((InetSocketAddress)future.channel().remoteAddress()).getHostString();
        if (future.isDone()) {
            RespAccessLogger.log(remoteAddress, data, status);
            return;
        }
        future.addListener(f -> RespAccessLogger.log(remoteAddress, data, status));
    }

    private static void log(String remoteAddress, AccessData data, String status) {
        long duration = data.start() == null ? -1L : ChronoUnit.MILLIS.between(data.start(), Instant.now());
        MDC.clear();
        MDC.put((String)"address", (Object)remoteAddress);
        MDC.put((String)"user", (Object)RespAccessLogger.parameter(data.principalName()));
        MDC.put((String)"method", (Object)RespAccessLogger.parameter(data.operation()));
        MDC.put((String)"protocol", (Object)"RESP");
        MDC.put((String)"status", (Object)RespAccessLogger.parameter(status));
        MDC.put((String)"responseSize", (Object)data.responseBytes());
        MDC.put((String)"requestSize", (Object)data.requestBytes());
        MDC.put((String)"duration", (Object)duration);
        log.tracef("/%s", (Object)RespAccessLogger.parameter(data.keys()));
    }

    private static String parameter(Object obj) {
        if (obj == null || obj instanceof String && ((String)obj).isEmpty()) {
            return "-";
        }
        if (obj instanceof byte[]) {
            return Util.printArray((byte[])((byte[])obj));
        }
        if (obj instanceof byte[][]) {
            boolean wrote = false;
            StringBuilder builder = new StringBuilder("[");
            for (byte[] b : (byte[][])obj) {
                wrote = true;
                builder.append(Util.printArray((byte[])b)).append(",");
            }
            if (wrote) {
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.append("]").toString();
        }
        return obj.toString();
    }
}

