/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6130)
public class JsonTypeFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<String>> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    private static final String STRING = "string";
    private static final String BOOLEAN = "boolean";
    private static final String INTEGER = "integer";
    private static final String NUMBER = "number";
    private static final String ARRAY = "array";
    private static final String NULL = "null";
    private static final String UNKNOWN = "unknown";
    private static final String OBJECT = "object";
    @ProtoField(value=1)
    final byte[] path;

    @ProtoFactory
    public JsonTypeFunction(byte[] path) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.path = path;
    }

    public List<String> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        if (doc == null) {
            return null;
        }
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(jpath);
            ArrayList<String> result = new ArrayList<String>();
            for (JsonNode jsonNode : nodeList) {
                result.add(this.mapType(jsonNode));
            }
            return result;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private String mapType(JsonNode jsonNode) {
        if (jsonNode.isTextual()) {
            return STRING;
        }
        if (jsonNode.isBoolean()) {
            return BOOLEAN;
        }
        if (jsonNode.isInt()) {
            return INTEGER;
        }
        if (jsonNode.isNumber()) {
            return NUMBER;
        }
        if (jsonNode.isArray()) {
            return ARRAY;
        }
        if (jsonNode.isNull()) {
            return NULL;
        }
        if (jsonNode.isObject()) {
            return OBJECT;
        }
        return UNKNOWN;
    }
}

