/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.cluster.SegmentSlotRelation;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.util.function.SerializableFunction;

public class SLOTS
extends RespCommand
implements Resp3Command {
    private static final BiConsumer<List<SlotInformation>, ResponseWriter> SERIALIZER = (res, writer) -> {
        writer.arrayStart(res.size());
        for (SlotInformation si : res) {
            writer.arrayNext();
            writer.write(si, si);
        }
        writer.arrayEnd();
    };
    @GuardedBy(value="this")
    private CompletionStage<List<SlotInformation>> lastExecution = null;
    @GuardedBy(value="this")
    private ConsistentHash lastAcceptedHash = null;

    public SLOTS() {
        super(2, 0, 0, 0, AclCategory.SLOW.mask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        AdvancedCache<byte[], byte[]> respCache = handler.cache();
        DistributionManager dm = respCache.getDistributionManager();
        if (dm == null) {
            handler.writer().customError("This instance has cluster support disabled");
            return handler.myStage();
        }
        LocalizedCacheTopology topology = dm.getCacheTopology();
        ConsistentHash hash = topology.getCurrentCH();
        if (hash == null) {
            handler.writer().customError("No consistent hash available");
            return handler.myStage();
        }
        SLOTS sLOTS = this;
        synchronized (sLOTS) {
            if (!hash.equals((Object)this.lastAcceptedHash)) {
                this.lastExecution = SLOTS.getSlotsInformation(handler, hash);
                this.lastAcceptedHash = hash;
            }
        }
        return handler.stageToReturn(this.lastExecution, ctx, SERIALIZER);
    }

    private static CompletionStage<List<SlotInformation>> getSlotsInformation(Resp3Handler handler, ConsistentHash hash) {
        return SLOTS.requestNodesNetworkInformation(hash.getMembers(), handler).thenApply(information -> {
            ArrayList<SlotInformation> response = new ArrayList<SlotInformation>();
            SegmentSlotRelation ssr = handler.respServer().segmentSlotRelation();
            int previousOwnedSegment = -1;
            List ownersForSegment = null;
            int slotWidth = ssr.slotWidth();
            int totalSegmentCount = hash.getNumSegments();
            for (int i = 0; i < totalSegmentCount; ++i) {
                List currentOwners = hash.locateOwnersForSegment(i);
                if (currentOwners.equals(ownersForSegment) && i != totalSegmentCount - 1) continue;
                if (ownersForSegment != null) {
                    int start = previousOwnedSegment * slotWidth;
                    int end = i * slotWidth - 1;
                    ArrayList<NodeInformation> nodes = new ArrayList<NodeInformation>();
                    for (Address owner : ownersForSegment) {
                        nodes.add(NodeInformation.create((List)information.get(owner)));
                    }
                    response.add(new SlotInformation(start, end, nodes));
                }
                ownersForSegment = currentOwners;
                previousOwnedSegment = i;
            }
            return response;
        });
    }

    private static CompletionStage<Map<Address, List<Object>>> requestNodesNetworkInformation(List<Address> members, Resp3Handler handler) {
        ConcurrentHashMap responses = new ConcurrentHashMap(members.size());
        ClusterExecutor executor = SecurityActions.getClusterExecutor(handler.cache());
        String name = handler.respServer().getQualifiedName();
        return executor.filterTargets(members).submitConsumer((SerializableFunction & Serializable)e -> SLOTS.readLocalInformation(name, e), (address, res, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            responses.put(address, res);
        }).thenApply(ignore -> responses);
    }

    private static List<Object> readLocalInformation(String serverName, EmbeddedCacheManager ecm) {
        ArrayList<Object> response = new ArrayList<Object>();
        ComponentRef ref = ((BasicComponentRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm).getComponent(BasicComponentRegistry.class)).getComponent(serverName, RespServer.class);
        if (ref == null) {
            return null;
        }
        RespServer server = (RespServer)((Object)ref.running());
        CacheManagerInfo info = ecm.getCacheManagerInfo();
        response.add(server.getHost());
        response.add(server.getPort());
        response.add(info.getNodeName());
        NettyTransport transport = server.getTransport();
        if (transport != null) {
            String host = transport.getHostName();
            response.add(List.of(host));
        } else {
            response.add(Collections.emptyList());
        }
        return response;
    }

    private record NodeInformation(String host, Integer port, String name, List<String> metadata) implements JavaObjectSerializer<NodeInformation>
    {
        @Override
        public void accept(NodeInformation ignore, ResponseWriter writer) {
            writer.arrayStart(4);
            writer.arrayNext();
            writer.string(this.host);
            writer.arrayNext();
            writer.integers(this.port);
            writer.arrayNext();
            writer.string(this.name);
            writer.arrayNext();
            writer.array(this.metadata, Resp3Type.BULK_STRING);
            writer.arrayEnd();
        }

        private static NodeInformation create(List<Object> values) {
            return new NodeInformation((String)values.get(0), (Integer)values.get(1), (String)values.get(2), (List)values.get(3));
        }
    }

    private record SlotInformation(int start, int end, List<NodeInformation> info) implements JavaObjectSerializer<SlotInformation>
    {
        @Override
        public void accept(SlotInformation si, ResponseWriter writer) {
            int size = 2 + si.info.size();
            writer.arrayStart(size);
            writer.arrayNext();
            writer.integers(si.start());
            writer.arrayNext();
            writer.integers(si.end());
            for (NodeInformation ni : si.info) {
                writer.arrayNext();
                writer.write(ni, ni);
            }
            writer.arrayEnd();
        }
    }
}

