/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6129)
public class JsonToggleFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Integer>> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    @ProtoField(value=1)
    final byte[] path;

    @ProtoFactory
    public JsonToggleFunction(byte[] path) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.path = path;
    }

    public List<Integer> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            throw new CacheException("could not perform this operation on a key that doesn't exist");
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext modifiableCtx = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext getForContext = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)modifiableCtx.read(jpath);
            boolean changed = false;
            ArrayList<Integer> resList = new ArrayList<Integer>(pathList.size());
            for (JsonNode pathAsNode : pathList) {
                String pathAsText = pathAsNode.asText();
                ArrayNode node = (ArrayNode)getForContext.read(pathAsText, new Predicate[0]);
                if (node.get(0).isBoolean()) {
                    boolean currentBolValue = node.get(0).asBoolean();
                    resList.add(currentBolValue ? 0 : 1);
                    if (JSONUtil.isRoot(pathAsText.getBytes(StandardCharsets.UTF_8))) {
                        entryView.set((Object)new JsonBucket(Boolean.toString(!currentBolValue).getBytes(StandardCharsets.UTF_8)), new MetaParam.Writable[0]);
                        return resList;
                    }
                    modifiableCtx.set(pathAsText, (Object)(currentBolValue ? BooleanNode.FALSE : BooleanNode.TRUE), new Predicate[0]);
                    changed = true;
                    continue;
                }
                resList.add(null);
            }
            if (changed) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return resList;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

