/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6126)
public class JsonObjkeysFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<List<byte[]>>> {
    @ProtoField(value=1)
    final byte[] path;

    @ProtoFactory
    public JsonObjkeysFunction(byte[] path) {
        this.path = path;
    }

    public List<List<byte[]>> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        Optional existing = entryView.peek();
        if (existing.isEmpty()) {
            return null;
        }
        byte[] doc = ((JsonBucket)existing.get()).value();
        ObjectMapper mapper = JSONUtil.objectMapper;
        try {
            JsonNode rootNode = mapper.readTree(RespUtil.utf8(doc));
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(RespUtil.utf8(this.path), new Predicate[0]);
            ArrayList<List<byte[]>> resultList = new ArrayList<List<byte[]>>();
            for (JsonNode jsonNode : nodeList) {
                if (jsonNode.isObject()) {
                    ObjectNode objNode = (ObjectNode)jsonNode;
                    ArrayList namesList = new ArrayList();
                    Iterator iterator = objNode.fieldNames();
                    iterator.forEachRemaining(k -> namesList.add(k.getBytes(StandardCharsets.UTF_8)));
                    resultList.add(namesList);
                    continue;
                }
                resultList.add(null);
            }
            return resultList;
        }
        catch (JsonProcessingException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

