/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetAddArgs;
import org.infinispan.multimap.impl.SortedSetSubsetArgs;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.LimitArgument;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.sortedset.ZSetCommonUtils;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class ZRANGE
extends RespCommand
implements Resp3Command {
    private boolean initialRev;
    private boolean initialByScore;
    private boolean initialByLex;

    public ZRANGE() {
        this(-4, Collections.emptySet());
    }

    protected ZRANGE(int arity, Set<Arg> args) {
        this(arity);
        this.initialRev = args.contains((Object)Arg.REV);
        this.initialByLex = args.contains((Object)Arg.BYLEX);
        this.initialByScore = args.contains((Object)Arg.BYSCORE);
    }

    protected ZRANGE(Set<Arg> args) {
        this(-4, args);
    }

    protected ZRANGE(int arity) {
        super(arity, 1, 1, 1, AclCategory.READ.mask() | AclCategory.SORTEDSET.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        CompletionStage getSortedSetCall;
        int pos = 0;
        byte[] destination = this.getArity() == -5 ? arguments.get(pos++) : null;
        byte[] name = arguments.get(pos++);
        byte[] start = arguments.get(pos++);
        byte[] stop = arguments.get(pos++);
        ResultOptions resultOpt = new ResultOptions();
        boolean isRev = this.initialRev;
        boolean byLex = this.initialByLex;
        boolean byScore = this.initialByScore;
        block9: while (pos < arguments.size()) {
            switch (Arg.valueOf(new String(arguments.get(pos++)).toUpperCase()).ordinal()) {
                case 3: {
                    LimitArgument limitArgument = LimitArgument.parse(handler, arguments, pos);
                    if (limitArgument.error) {
                        return handler.myStage();
                    }
                    resultOpt.offset = limitArgument.offset;
                    resultOpt.count = limitArgument.count;
                    pos = limitArgument.nextArgPos;
                    continue block9;
                }
                case 0: {
                    byScore = true;
                    continue block9;
                }
                case 1: {
                    byLex = true;
                    continue block9;
                }
                case 2: {
                    isRev = true;
                    continue block9;
                }
                case 4: {
                    resultOpt.withScores = true;
                    continue block9;
                }
            }
            handler.writer().syntaxError();
            return handler.myStage();
        }
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache = handler.getSortedSeMultimap();
        if (byLex && byScore) {
            handler.writer().syntaxError();
            return handler.myStage();
        }
        if (!byLex && !byScore && resultOpt.offset != null) {
            handler.writer().customError("syntax error, LIMIT is only supported in combination with either BYSCORE or BYLEX");
            return handler.myStage();
        }
        if (byLex && resultOpt.withScores) {
            handler.writer().customError("syntax error, WITHSCORES not supported in combination with BYLEX");
            return handler.myStage();
        }
        if (byScore) {
            ZSetCommonUtils.Score startScore = ZSetCommonUtils.parseScore(start);
            ZSetCommonUtils.Score stopScore = ZSetCommonUtils.parseScore(stop);
            if (startScore == null || stopScore == null) {
                handler.writer().minOrMaxNotAValidFloat();
                return handler.myStage();
            }
            SortedSetSubsetArgs.Builder builder = SortedSetSubsetArgs.create();
            builder.isRev(isRev);
            builder.start((Object)startScore.value);
            builder.includeStart(startScore.include);
            builder.stop((Object)stopScore.value);
            builder.includeStop(stopScore.include);
            builder.offset(resultOpt.offset);
            builder.count(resultOpt.count);
            getSortedSetCall = sortedSetCache.subsetByScore((Object)name, builder.build());
        } else if (byLex) {
            ZSetCommonUtils.Lex startLex = ZSetCommonUtils.parseLex(start);
            ZSetCommonUtils.Lex stopLex = ZSetCommonUtils.parseLex(stop);
            if (startLex == null || stopLex == null) {
                handler.writer().minOrMaxNotAValidStringRange();
                return handler.myStage();
            }
            SortedSetSubsetArgs.Builder builder = SortedSetSubsetArgs.create();
            builder.isRev(isRev);
            builder.start((Object)startLex.value);
            builder.includeStart(startLex.include);
            builder.stop((Object)stopLex.value);
            builder.includeStop(stopLex.include);
            builder.offset(resultOpt.offset);
            builder.count(resultOpt.count);
            getSortedSetCall = sortedSetCache.subsetByLex((Object)name, builder.build());
        } else {
            long to;
            long from;
            try {
                from = ArgumentUtils.toLong(start);
                to = ArgumentUtils.toLong(stop);
            }
            catch (NumberFormatException ex) {
                handler.writer().valueNotInteger();
                return handler.myStage();
            }
            SortedSetSubsetArgs.Builder builder = SortedSetSubsetArgs.create();
            builder.isRev(isRev);
            builder.start((Object)from);
            builder.stop((Object)to);
            getSortedSetCall = sortedSetCache.subsetByIndex((Object)name, builder.build());
        }
        if (destination != null) {
            return this.rangeAndStore(handler, ctx, destination, sortedSetCache, getSortedSetCall);
        }
        CompletionStage<ZSetCommonUtils.ZOperationResponse> cs = getSortedSetCall.thenApply(subsetResult -> ZSetCommonUtils.response(subsetResult, resultOpt.withScores));
        return handler.stageToReturn(cs, ctx, ResponseWriter.CUSTOM);
    }

    private CompletionStage<RespRequestHandler> rangeAndStore(Resp3Handler handler, ChannelHandlerContext ctx, byte[] destination, EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache, CompletionStage<Collection<ScoredValue<byte[]>>> getSortedSetCall) {
        CompletionStage cs = getSortedSetCall.thenCompose(scoredValues -> sortedSetCache.addMany((Object)destination, scoredValues, SortedSetAddArgs.create().replace().build()));
        return handler.stageToReturn(cs, ctx, ResponseWriter.INTEGER);
    }

    public static enum Arg {
        BYSCORE,
        BYLEX,
        REV,
        LIMIT,
        WITHSCORES;

    }

    static class ResultOptions {
        boolean withScores = false;
        Long offset = null;
        Long count = null;

        ResultOptions() {
        }
    }
}

