/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class TIME
extends RespCommand
implements Resp3Command {
    public TIME() {
        super(1, 0, 0, 0, AclCategory.FAST.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        Instant now = handler.respServer().getTimeService().instant();
        byte[] nowSec = String.valueOf(now.getEpochSecond()).getBytes(StandardCharsets.US_ASCII);
        byte[] nowMicro = String.valueOf(TimeUnit.NANOSECONDS.toMicros(now.getNano())).getBytes(StandardCharsets.US_ASCII);
        CompletableFuture stage = CompletableFuture.completedFuture(Arrays.asList(nowSec, nowMicro));
        return handler.stageToReturn(stage, ctx, ResponseWriter.ARRAY_BULK_STRING);
    }
}

