/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Version;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Type;

public class MODULE
extends RespCommand
implements Resp3Command {
    public MODULE() {
        super(-1, 0, 0, 0, AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        String subcommand;
        handler.checkPermission(AuthorizationPermission.ADMIN);
        switch (subcommand = new String(arguments.get(0), StandardCharsets.UTF_8).toUpperCase()) {
            case "LIST": {
                handler.writer().array(MODULE.allModulesRESP2(), Resp3Type.AUTO);
                break;
            }
            case "LOAD": 
            case "LOADEX": 
            case "UNLOAD": {
                handler.writer().customError("module loading/unloading unsupported");
            }
        }
        return handler.myStage();
    }

    public static List<List<Object>> allModulesRESP2() {
        long rVersion = Long.parseLong(Version.getMajor()) * 10000L + Long.parseLong(Version.getMinor()) * 100L + Long.parseLong(Version.getPatch());
        List jsonModule = List.of("name", "ReJSON", "ver", Long.valueOf(rVersion), "path", "internal", "args", Collections.emptyList());
        return List.of(jsonModule);
    }

    public static List<Map<String, Object>> allModulesRESP3() {
        long rVersion = Long.parseLong(Version.getMajor()) * 10000L + Long.parseLong(Version.getMinor()) * 100L + Long.parseLong(Version.getPatch());
        LinkedHashMap<String, Object> jsonModule = new LinkedHashMap<String, Object>(4);
        jsonModule.put("name", "ReJSON");
        jsonModule.put("ver", rVersion);
        jsonModule.put("path", "internal");
        jsonModule.put("args", Collections.emptyList());
        return List.of(jsonModule);
    }
}

