/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.context.Flag;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.impl.EmbeddedMultimapListCache;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.Resp3AuthHandler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.json.EmbeddedJsonCache;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.concurrent.BlockingManager;

public class Resp3Handler
extends Resp3AuthHandler {
    protected AdvancedCache<byte[], byte[]> ignorePreviousValueCache;
    protected EmbeddedMultimapListCache<byte[], byte[]> listMultimap;
    protected EmbeddedMultimapPairCache<byte[], byte[], byte[]> mapMultimap;
    protected EmbeddedSetCache<byte[], byte[]> embeddedSetCache;
    protected EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetMultimap;
    protected EmbeddedJsonCache jsonCache;
    protected final ScheduledExecutorService scheduler;
    protected final BlockingManager blockingManager;
    private final MediaType valueMediaType;

    Resp3Handler(RespServer respServer, MediaType valueMediaType, AdvancedCache<byte[], byte[]> cache) {
        super(respServer, cache);
        this.valueMediaType = valueMediaType;
        GlobalComponentRegistry gcr = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)respServer.getCacheManager());
        this.scheduler = (ScheduledExecutorService)gcr.getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout");
        this.blockingManager = (BlockingManager)gcr.getComponent(BlockingManager.class);
    }

    protected Resp3Handler(Resp3Handler delegate) {
        this(delegate.respServer, delegate.valueMediaType, delegate.cache());
    }

    @Override
    public void setCache(AdvancedCache<byte[], byte[]> cache) {
        super.setCache(cache);
        this.ignorePreviousValueCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES});
        AdvancedCache toMultimap = cache.withMediaType(MediaType.APPLICATION_OCTET_STREAM, this.valueMediaType);
        this.listMultimap = new EmbeddedMultimapListCache((Cache)toMultimap);
        this.mapMultimap = new EmbeddedMultimapPairCache((Cache)toMultimap);
        this.embeddedSetCache = new EmbeddedSetCache((Cache)toMultimap);
        this.sortedSetMultimap = new EmbeddedMultimapSortedSetCache((Cache)toMultimap);
        this.jsonCache = new EmbeddedJsonCache((Cache<byte[], JsonBucket>)toMultimap);
    }

    public EmbeddedJsonCache getJsonCache() {
        return this.jsonCache;
    }

    public EmbeddedMultimapListCache<byte[], byte[]> getListMultimap() {
        return this.listMultimap;
    }

    public EmbeddedMultimapPairCache<byte[], byte[], byte[]> getHashMapMultimap() {
        return this.mapMultimap;
    }

    public EmbeddedSetCache<byte[], byte[]> getEmbeddedSetCache() {
        return this.embeddedSetCache;
    }

    public EmbeddedMultimapSortedSetCache<byte[], byte[]> getSortedSeMultimap() {
        return this.sortedSetMultimap;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public BlockingManager getBlockingManager() {
        return this.blockingManager;
    }

    @Override
    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
        if (type instanceof Resp3Command) {
            Resp3Command resp3Command = (Resp3Command)((Object)type);
            return resp3Command.perform(this, ctx, arguments);
        }
        return super.actualHandleRequest(ctx, type, arguments);
    }

    public AdvancedCache<byte[], byte[]> ignorePreviousValuesCache() {
        return this.ignorePreviousValueCache;
    }

    public CompletionStage<RespRequestHandler> delegate(ChannelHandlerContext ctx, RespCommand command, List<byte[]> arguments) {
        return super.actualHandleRequest(ctx, command, arguments);
    }

    public void checkPermission(AuthorizationPermission authorizationPermission) {
        AuthorizationManager authorizationManager = this.cache().getAuthorizationManager();
        if (authorizationManager != null) {
            authorizationManager.checkPermission(authorizationPermission);
        }
    }
}

