/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JsonNumOpFunction;

@ProtoTypeId(value=6125)
public class JsonNumMultOpFunction
extends JsonNumOpFunction {
    @ProtoFactory
    public JsonNumMultOpFunction(byte[] path, byte[] value) {
        super(path, value);
    }

    @Override
    protected Number operate(JsonNode numNode, JsonNode multiply) {
        if (numNode.isDouble() || multiply.isDouble()) {
            return numNode.doubleValue() * multiply.doubleValue();
        }
        if (numNode.isFloat() || multiply.isFloat()) {
            return Float.valueOf(numNode.floatValue() * multiply.floatValue());
        }
        if (numNode.isLong() || multiply.isLong()) {
            return numNode.longValue() * multiply.longValue();
        }
        if (numNode.isBigInteger() || multiply.isBigInteger()) {
            return numNode.bigIntegerValue().multiply(multiply.bigIntegerValue());
        }
        if (numNode.isBigDecimal() || multiply.isBigDecimal()) {
            return new BigDecimal(numNode.asText()).multiply(new BigDecimal(multiply.asText()));
        }
        return numNode.intValue() * multiply.intValue();
    }
}

