/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.tx;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.server.resp.CacheRespRequestHandler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.SubscriberHandler;
import org.infinispan.server.resp.commands.TransactionResp3Command;
import org.infinispan.server.resp.commands.pubsub.PSUBSCRIBE;
import org.infinispan.server.resp.commands.pubsub.SUBSCRIBE;
import org.infinispan.server.resp.commands.tx.UNWATCH;
import org.infinispan.server.resp.commands.tx.WATCH;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.tx.TransactionCommand;

public class RespTransactionHandler
extends CacheRespRequestHandler {
    private final List<TransactionCommand> queued = new ArrayList<TransactionCommand>();
    private boolean failed;

    public RespTransactionHandler(RespServer respServer, AdvancedCache<byte[], byte[]> cache) {
        super(respServer, cache);
    }

    @Override
    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand command, List<byte[]> arguments) {
        this.initializeIfNecessary(ctx);
        if (command instanceof SUBSCRIBE || command instanceof PSUBSCRIBE) {
            CompletionStage<?> drop = this.dropTransaction(ctx);
            SubscriberHandler subscriberHandler = new SubscriberHandler(this.respServer(), this.respServer().newHandler(this.cache()));
            return subscriberHandler.handleRequest(ctx, command, arguments).thenCombine(drop, (handler, ignore) -> handler);
        }
        if (command instanceof TransactionResp3Command) {
            TransactionResp3Command tx = (TransactionResp3Command)((Object)command);
            return tx.perform(this, ctx, arguments);
        }
        if (!this.isCommandValid(command, arguments)) {
            return this.myStage();
        }
        try {
            this.queued.add(new TransactionCommand(command, List.copyOf(arguments)));
        }
        catch (Throwable t) {
            this.errorInTransactionContext();
            return command.handleException(this, t);
        }
        return this.stageToReturn(this.myStage(), ctx, (? super E h, ResponseWriter writer) -> writer.queued(h));
    }

    @Override
    protected void commandNotFound() {
        super.commandNotFound();
        this.errorInTransactionContext();
    }

    @Override
    public void handleChannelDisconnect(ChannelHandlerContext ctx) {
        this.dropTransaction(ctx);
    }

    private boolean isCommandValid(RespCommand command, List<byte[]> arguments) {
        if (!command.hasValidNumberOfArguments(arguments)) {
            this.writer().wrongArgumentNumber(command);
            return false;
        }
        return true;
    }

    public void errorInTransactionContext() {
        this.failed = true;
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public CompletionStage<?> dropTransaction(ChannelHandlerContext ctx) {
        this.queued.clear();
        return this.unregisterListeners(ctx);
    }

    public CompletionStage<List<TransactionCommand>> performingOperations(ChannelHandlerContext ctx) {
        return this.unregisterListeners(ctx).thenApply(watchers -> {
            if (watchers != null) {
                for (WATCH.TxKeysListener watcher : watchers) {
                    if (!watcher.hasSeenEvents()) continue;
                    return null;
                }
            }
            return this.queued;
        });
    }

    public CompletionStage<List<WATCH.TxKeysListener>> unregisterListeners(ChannelHandlerContext ctx) {
        return UNWATCH.deregister(ctx, this.cache(), this.respServer().metadataRepository().client());
    }
}

