/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.server.resp.json.JsonBucket;

public class MemoryEntrySizeUtils {
    private static PrimitiveEntrySizeCalculator pesc = new PrimitiveEntrySizeCalculator();
    private static CacheEntrySizeCalculator<byte[], Object> cesc = new CacheEntrySizeCalculator(MemoryEntrySizeUtils::internalCalculateSize);
    private static SizeOf sizeof = SizeOf.newInstance((SizeOfFilter[])new SizeOfFilter[0]);

    public static long calculateSize(byte[] key, InternalCacheEntry<byte[], Object> ice) {
        return cesc.calculateSize((Object)key, ice);
    }

    public static long calculateSize(Object o) {
        return sizeof.deepSizeOf(new Object[]{o});
    }

    static long internalCalculateSize(byte[] key, Object value) {
        try {
            if (value instanceof JsonBucket) {
                JsonBucket jb = (JsonBucket)value;
                return sizeof.deepSizeOf(new Object[]{key}) + sizeof.deepSizeOf(new Object[]{jb.value()}) + JsonBucket.memoryHeaderSize();
            }
            return sizeof.deepSizeOf(new Object[]{key}) + sizeof.deepSizeOf(new Object[]{value});
        }
        catch (Exception ex) {
            return pesc.calculateSize((Object)key, value);
        }
    }
}

