/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import java.util.ArrayList;
import java.util.List;

public enum AclCategory {
    KEYSPACE(1L),
    READ(2L),
    WRITE(4L),
    SET(8L),
    SORTEDSET(16L),
    LIST(32L),
    HASH(64L),
    STRING(128L),
    BITMAP(256L),
    HYPERLOGLOG(512L),
    GEO(1024L),
    STREAM(2048L),
    PUBSUB(4096L),
    ADMIN(8192L),
    FAST(16384L),
    SLOW(32768L),
    BLOCKING(65536L),
    DANGEROUS(131072L),
    CONNECTION(262144L),
    TRANSACTION(524288L),
    SCRIPTING(0x100000L),
    BLOOM(0x200000L),
    CUCKOO(0x400000L),
    CMS(0x800000L),
    TOPK(0x1000000L),
    TDIGEST(0x2000000L),
    SEARCH(0x4000000L),
    TIMESERIES(0x8000000L),
    JSON(0x10000000L);

    private final long mask;

    private AclCategory(long mask) {
        this.mask = mask;
    }

    public long mask() {
        return this.mask;
    }

    public boolean matches(long mask) {
        return (mask & this.mask) == this.mask;
    }

    public String toString() {
        return "@" + this.name().toLowerCase();
    }

    public static List<String> aclNames(long mask) {
        ArrayList<String> names = new ArrayList<String>();
        for (AclCategory c : AclCategory.values()) {
            if (!c.matches(mask)) continue;
            names.add(c.toString());
        }
        return names;
    }
}

