/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6128)
public class JsonStringAppendFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Long>> {
    @ProtoField(value=1)
    final byte[] path;
    @ProtoField(value=2)
    final byte[] value;

    @ProtoFactory
    public JsonStringAppendFunction(byte[] path, byte[] value) {
        this.path = path;
        this.value = value;
    }

    public List<Long> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            throw new CacheException("could not perform this operation on a key that doesn't exist");
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtxPath = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)jpCtxPath.read(jpath);
            ArrayList<Long> resList = new ArrayList<Long>();
            boolean changed = false;
            JsonNode textNode = JSONUtil.objectMapper.readTree(this.value);
            for (JsonNode pathAsNode : pathList) {
                String asText = pathAsNode.asText();
                ArrayNode node = (ArrayNode)jpCtx.read(asText, new Predicate[0]);
                if (node.get(0).isTextual()) {
                    String newString;
                    if (JSONUtil.isRoot(asText.getBytes(StandardCharsets.UTF_8))) {
                        newString = "\"" + node.get(0).textValue() + textNode.textValue() + "\"";
                        entryView.set((Object)new JsonBucket(newString.getBytes(StandardCharsets.UTF_8)), new MetaParam.Writable[0]);
                        resList.add((long)newString.length() - 2L);
                        return resList;
                    }
                    newString = node.get(0).textValue() + textNode.textValue();
                    jpCtx.set(asText, (Object)TextNode.valueOf((String)newString), new Predicate[0]);
                    changed = true;
                    resList.add(Long.valueOf(newString.length()));
                    continue;
                }
                resList.add(null);
            }
            if (changed) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return resList;
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

