/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonRespFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Object>> {
    public static final AdvancedExternalizer<JsonRespFunction> EXTERNALIZER = new Externalizer();
    private byte[] path;

    public JsonRespFunction(byte[] path) {
        this.path = path;
    }

    public List<Object> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            return null;
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(jpath);
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode jsonNode : nodeList) {
                result.add(this.resp(jsonNode));
            }
            return result;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private Object resp(JsonNode jsonNode) {
        if (jsonNode.isArray()) {
            ArrayList<Object> arr = new ArrayList<Object>();
            arr.add("[");
            for (JsonNode jsonNode2 : (ArrayNode)jsonNode) {
                arr.add(this.resp(jsonNode2));
            }
            return arr;
        }
        if (jsonNode.isObject()) {
            ArrayList<String> obj = new ArrayList<String>();
            obj.add("{");
            jsonNode.fields().forEachRemaining(entry -> {
                obj.add((String)entry.getKey());
                obj.add((String)this.resp((JsonNode)entry.getValue()));
            });
            return obj;
        }
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isLong()) {
            return jsonNode.asLong();
        }
        if (jsonNode.isFloat() || jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        if (jsonNode.isNull()) {
            return null;
        }
        return jsonNode.toString();
    }

    public static class Externalizer
    implements AdvancedExternalizer<JsonRespFunction> {
        public void writeObject(ObjectOutput output, JsonRespFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
        }

        public JsonRespFunction readObject(ObjectInput input) throws IOException {
            byte[] path = JSONUtil.readBytes(input);
            return new JsonRespFunction(path);
        }

        public Set<Class<? extends JsonRespFunction>> getTypeClasses() {
            return Collections.singleton(JsonRespFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_RESP_FUNCTION;
        }
    }
}

