/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.server.resp.json.JsonLenFunction;
import org.infinispan.util.function.SerializableFunction;

public class JsonLenStrFunction
extends JsonLenFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Long>> {
    public static final AdvancedExternalizer<JsonLenStrFunction> EXTERNALIZER = new Externalizer();

    public JsonLenStrFunction(byte[] path) {
        super(path, JsonNode::isTextual, jsonNode -> jsonNode.asText().length());
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonLenStrFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonLenStrFunction jsonLenFunction) throws IOException {
            JSONUtil.writeBytes(output, jsonLenFunction.path);
        }

        public JsonLenStrFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] path = JSONUtil.readBytes(input);
            return new JsonLenStrFunction(path);
        }

        public Set<Class<? extends JsonLenStrFunction>> getTypeClasses() {
            return Collections.singleton(JsonLenStrFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_LEN_STR_FUNCTION;
        }
    }
}

