/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public abstract class JsonNumOpFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Number>> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    public static final String ERR_INCREMENT_CANT_BE_NULL = "increment can't be null";
    protected byte[] path;
    protected byte[] value;

    public JsonNumOpFunction(byte[] path, byte[] increment) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        Objects.requireNonNull(increment, ERR_INCREMENT_CANT_BE_NULL);
        this.value = increment;
        this.path = path;
    }

    public List<Number> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonNode incrNode;
        try {
            incrNode = JSONUtil.objectMapper.readTree(this.value);
            if (!incrNode.isNumber()) {
                throw new IllegalArgumentException("Non a valid increment number: " + incrNode.asText());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            throw new CacheException("could not perform this operation on a key that doesn't exist");
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext modifiableCtx = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext getForContext = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)modifiableCtx.read(jpath);
            boolean changed = false;
            ArrayList<Number> resList = new ArrayList<Number>(pathList.size());
            for (JsonNode pathAsNode : pathList) {
                String pathAsText = pathAsNode.asText();
                ArrayNode node = (ArrayNode)getForContext.read(pathAsText, new Predicate[0]);
                if (node.get(0).isNumber()) {
                    Number incremented;
                    if (JSONUtil.isRoot(pathAsText.getBytes(StandardCharsets.UTF_8))) {
                        incremented = this.operate(node.get(0), incrNode);
                        String jsonNumberValue = String.valueOf(incremented);
                        entryView.set((Object)new JsonBucket(jsonNumberValue.getBytes(StandardCharsets.UTF_8)), new MetaParam.Writable[0]);
                        resList.add(incremented);
                        return resList;
                    }
                    incremented = this.operate(node.get(0), incrNode);
                    modifiableCtx.set(pathAsText, (Object)incremented, new Predicate[0]);
                    resList.add(incremented);
                    changed = true;
                    continue;
                }
                resList.add(null);
            }
            if (changed) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return resList;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected abstract Number operate(JsonNode var1, JsonNode var2);
}

