/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonDelFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, Long> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    public static final AdvancedExternalizer<JsonDelFunction> EXTERNALIZER = new Externalizer();
    byte[] path;

    public JsonDelFunction(byte[] path) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.path = path;
    }

    public Long apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            return 0L;
        }
        byte[] jsonPath = JSONUtil.toJsonPath(this.path);
        try {
            JsonNode rootObjectNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootObjectNode);
            if (JSONUtil.isRoot(jsonPath)) {
                entryView.remove();
                return 1L;
            }
            String pathStr = new String(jsonPath, StandardCharsets.UTF_8);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode an = (ArrayNode)jpCtx.read(jpath);
            if (an.size() == 0 || an.size() == 1 && an.get(0) == null) {
                return 0L;
            }
            jpCtx = jpCtx.delete(jpath);
            entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootObjectNode)), new MetaParam.Writable[0]);
            return an.size();
        }
        catch (IndexOutOfBoundsException e) {
            return 0L;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonDelFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonDelFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
        }

        public JsonDelFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] path = JSONUtil.readBytes(input);
            return new JsonDelFunction(path);
        }

        public Set<Class<? extends JsonDelFunction>> getTypeClasses() {
            return Collections.singleton(JsonDelFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_DEL_FUNCTION;
        }
    }
}

