/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonArrtrimFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Integer>> {
    public static final AdvancedExternalizer<JsonArrtrimFunction> EXTERNALIZER = new Externalizer();
    private byte[] path;
    private int start;
    private int stop;

    public JsonArrtrimFunction(byte[] path, int start, int stop) {
        this.path = path;
        this.start = start;
        this.stop = stop;
    }

    public List<Integer> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            return null;
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtxPath = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)jpCtxPath.read(jpath);
            ArrayList<Integer> resList = new ArrayList<Integer>();
            boolean changed = false;
            for (JsonNode pathAsNode : pathList) {
                ArrayNode node = (ArrayNode)jpCtx.read(pathAsNode.asText(), new Predicate[0]);
                if (node.get(0).isArray()) {
                    int stop;
                    ArrayNode destNode = (ArrayNode)node.get(0);
                    int start = JsonArrtrimFunction.toTrimStartIndex(this.start, destNode.size());
                    if (start > (stop = JsonArrtrimFunction.toTrimStopIndex(this.stop, destNode.size())) || start >= destNode.size()) {
                        if (destNode.size() > 0) {
                            destNode.removeAll();
                            changed = true;
                        }
                    } else {
                        int i;
                        for (i = destNode.size() - 1; i > stop; --i) {
                            destNode.remove(i);
                            changed = true;
                        }
                        for (i = 0; i < start; ++i) {
                            destNode.remove(0);
                            changed = true;
                        }
                    }
                    if (JSONUtil.isRoot(pathAsNode.asText().getBytes(StandardCharsets.UTF_8))) {
                        if (changed) {
                            entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)destNode)), new MetaParam.Writable[0]);
                        }
                        resList.add(destNode.size());
                        return resList;
                    }
                    jpCtx.set(pathAsNode.asText(), (Object)destNode, new Predicate[0]);
                    resList.add(destNode.size());
                    continue;
                }
                resList.add(null);
            }
            if (changed) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return resList;
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static int toTrimStartIndex(int start, int size) {
        if (start < 0) {
            return Math.max(size + start, 0);
        }
        return Math.min(start, size);
    }

    private static int toTrimStopIndex(int stop, int size) {
        if (stop < 0) {
            return Math.max(size + stop, 0);
        }
        return Math.min(stop, size - 1);
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonArrtrimFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonArrtrimFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
            output.writeInt(object.start);
            output.writeInt(object.stop);
        }

        public JsonArrtrimFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] jsonPath = JSONUtil.readBytes(input);
            int start = input.readInt();
            int stop = input.readInt();
            return new JsonArrtrimFunction(jsonPath, start, stop);
        }

        public Set<Class<? extends JsonArrtrimFunction>> getTypeClasses() {
            return Collections.singleton(JsonArrtrimFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_ARRTRIM_FUNCTION;
        }
    }
}

