/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset.internal;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.sortedset.ZSetCommonUtils;
import org.infinispan.server.resp.serialization.ResponseWriter;

public abstract class ZREMRANGE
extends RespCommand
implements Resp3Command {
    private final Type type;

    protected ZREMRANGE(int arity, Type type) {
        super(arity, 1, 1, 1);
        this.type = type;
    }

    @Override
    public long aclMask() {
        return AclCategory.WRITE | AclCategory.SORTEDSET | AclCategory.SLOW;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        CompletionStage removeAllCall;
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache = handler.getSortedSeMultimap();
        int pos = 0;
        byte[] name = arguments.get(pos++);
        byte[] start = arguments.get(pos++);
        byte[] stop = arguments.get(pos++);
        if (this.type == Type.SCORE) {
            ZSetCommonUtils.Score startScore = ZSetCommonUtils.parseScore(start);
            ZSetCommonUtils.Score stopScore = ZSetCommonUtils.parseScore(stop);
            if (startScore == null || stopScore == null) {
                handler.writer().minOrMaxNotAValidFloat();
                return handler.myStage();
            }
            removeAllCall = sortedSetCache.removeAll((Object)name, startScore.value, startScore.include, stopScore.value, stopScore.include);
        } else if (this.type == Type.LEX) {
            ZSetCommonUtils.Lex startLex = ZSetCommonUtils.parseLex(start);
            ZSetCommonUtils.Lex stopLex = ZSetCommonUtils.parseLex(stop);
            if (startLex == null || stopLex == null) {
                handler.writer().customError("min or max not valid string range item");
                return handler.myStage();
            }
            removeAllCall = sortedSetCache.removeAll((Object)name, (Object)startLex.value, startLex.include, (Object)stopLex.value, stopLex.include);
        } else {
            long to;
            long from;
            try {
                from = ArgumentUtils.toLong(start);
                to = ArgumentUtils.toLong(stop);
            }
            catch (NumberFormatException ex) {
                handler.writer().valueNotInteger();
                return handler.myStage();
            }
            removeAllCall = sortedSetCache.removeAll((Object)name, Long.valueOf(from), Long.valueOf(to));
        }
        return handler.stageToReturn(removeAllCall, ctx, ResponseWriter.INTEGER);
    }

    protected static enum Type {
        RANK,
        SCORE,
        LEX;

    }
}

