/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.json;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.commons.CacheException;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.ResponseWriter;

public abstract class JSONAPPEND
extends RespCommand
implements Resp3Command {
    protected JSONAPPEND(String name, int arity, int firstKeyPos, int lastKeyPos, int steps) {
        super(name, arity, firstKeyPos, lastKeyPos, steps);
    }

    protected CompletionStage<RespRequestHandler> returnResult(Resp3Handler handler, ChannelHandlerContext ctx, byte[] jsonPath, boolean isLegacy, CompletionStage<List<Long>> lengths) {
        if (isLegacy) {
            return handler.stageToReturn(lengths, ctx, JSONAPPEND.newIntegerOrErrorWriter(jsonPath, this.getOpType()));
        }
        return handler.stageToReturn(lengths, ctx, ResponseWriter.ARRAY_INTEGER);
    }

    @Override
    public long aclMask() {
        return 0L;
    }

    static BiConsumer<List<Long>, ResponseWriter> newIntegerOrErrorWriter(byte[] path, String opType) {
        return (c, writer) -> {
            if (c == null || c.size() == 0 || c.get(0) == null) {
                throw new CacheException("Path '" + RespUtil.ascii(path) + "' does not exist or not a " + opType);
            }
            for (int i = c.size() - 1; i >= 0; --i) {
                if (c.get(i) == null) continue;
                writer.integers((Number)c.get(i));
                return;
            }
        };
    }

    protected abstract String getOpType();
}

