/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.scripting;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptWithMetadata;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.scripting.LuaArray;
import org.infinispan.server.resp.scripting.LuaCode;
import org.infinispan.server.resp.scripting.LuaContext;
import org.infinispan.server.resp.scripting.LuaContextPool;
import org.infinispan.server.resp.scripting.LuaMap;
import org.infinispan.server.resp.scripting.LuaSet;
import org.infinispan.server.resp.scripting.ScriptFlags;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.serialization.SerializationHint;
import org.infinispan.server.resp.serialization.lua.LuaResponseWriter;
import org.infinispan.server.resp.tx.TransactionContext;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.util.concurrent.BlockingManager;
import party.iroiro.luajava.Lua;

public class LuaTaskEngine
implements TaskEngine {
    private final LuaContextPool pool;
    private final ScriptingManager scriptingManager;

    public LuaTaskEngine(ScriptingManager scriptingManager) {
        this.scriptingManager = scriptingManager;
        this.pool = new LuaContextPool(LuaContext::new, 2, 4);
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    public CompletionStage<Void> eval(Resp3Handler handler, ChannelHandlerContext ctx, String code, String[] keys, String[] args, long flags) {
        return handler.getBlockingManager().supplyBlocking(() -> {
            LuaContext luaCtx = this.pool.borrow();
            try {
                LuaCode script = this.scriptLoad(code, false);
                luaCtx.registerScript(script);
                this.runScript(luaCtx, handler, ctx, script, keys, args, flags);
                luaCtx.unregisterScript(script);
                return luaCtx;
            }
            catch (Throwable t) {
                luaCtx.shutdown();
                handler.writer().error(t);
                return null;
            }
        }, (Object)"eval").thenApplyAsync(luaCtx -> {
            if (luaCtx != null) {
                this.luaToResp(luaCtx.lua, handler);
                luaCtx.lua.pop(1);
                this.pool.returnToPool((LuaContext)luaCtx);
            }
            return null;
        }, (Executor)ctx.channel().eventLoop());
    }

    public CompletionStage<Void> evalSha(Resp3Handler handler, ChannelHandlerContext ctx, String sha, String[] keys, String[] args, long flags) {
        return handler.getBlockingManager().supplyBlocking(() -> {
            ScriptWithMetadata script;
            LuaContext luaCtx = this.pool.borrow();
            try {
                script = this.scriptingManager.getScriptWithMetadata(LuaTaskEngine.scriptName(sha.toUpperCase()));
            }
            catch (CacheException e) {
                this.pool.returnToPool(luaCtx);
                throw new RuntimeException("NOSCRIPT No matching script. Please use EVAL.");
            }
            try {
                LuaCode code = LuaCode.fromScript(script);
                luaCtx.registerScript(code);
                this.runScript(luaCtx, handler, ctx, code, keys, args, flags);
                return luaCtx;
            }
            catch (Throwable t) {
                luaCtx.shutdown();
                handler.writer().error(t);
                return null;
            }
        }, (Object)"evalsha").thenApplyAsync(luaCtx -> {
            if (luaCtx != null) {
                this.luaToResp(luaCtx.lua, handler);
                luaCtx.lua.pop(1);
                this.pool.returnToPool((LuaContext)luaCtx);
            }
            return null;
        }, (Executor)ctx.channel().eventLoop());
    }

    private void runScript(LuaContext luaCtx, Resp3Handler handler, ChannelHandlerContext ctx, LuaCode script, String[] keys, String[] args, long flags) {
        luaCtx.handler = handler;
        luaCtx.ctx = ctx;
        luaCtx.flags = flags;
        luaCtx.flags |= script.flags();
        ResponseWriter oldWriter = handler.writer(new LuaResponseWriter(luaCtx.lua));
        try {
            TransactionContext.startTransactionContext(ctx);
            this.runScript(luaCtx.lua, script, keys, args);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            TransactionContext.endTransactionContext(ctx);
            handler.writer(oldWriter);
        }
    }

    private void luaToResp(Lua lua, Resp3Handler handler) {
        try {
            lua.checkStack(4);
        }
        catch (RuntimeException e) {
            handler.writer().customError("reached lua stack limit");
            lua.pop(1);
            return;
        }
        switch (lua.type(-1)) {
            case STRING: {
                handler.writer().string(lua.toString(-1));
                break;
            }
            case BOOLEAN: {
                handler.writer().booleans(lua.toBoolean(-1));
                break;
            }
            case NUMBER: {
                handler.writer().integers((long)lua.toNumber(-1));
                break;
            }
            case TABLE: {
                lua.push("err");
                lua.rawGet(-2);
                if (lua.type(-1) == Lua.LuaType.STRING) {
                    lua.pop(1);
                    ErrorInfo errorInfo = this.extractErrorInformation(lua);
                    handler.writer().error("-" + errorInfo.message);
                    lua.pop(1);
                    return;
                }
                lua.pop(1);
                lua.push("ok");
                lua.rawGet(-2);
                if (lua.type(-1) == Lua.LuaType.STRING) {
                    String ok = lua.toString(-1).replaceAll("[\\r\\n]", " ");
                    handler.writer().string(ok);
                    lua.pop(2);
                    return;
                }
                lua.pop(1);
                lua.push("double");
                lua.rawGet(-2);
                if (lua.type(-1) == Lua.LuaType.NUMBER) {
                    handler.writer().doubles(lua.toNumber(-1));
                    lua.pop(2);
                    return;
                }
                lua.pop(1);
                lua.push("map");
                lua.rawGet(-2);
                if (lua.type(-1) == Lua.LuaType.TABLE) {
                    lua.push("len");
                    lua.rawGet(-3);
                    int size = (int)lua.toInteger(-1);
                    lua.pop(1);
                    LuaMap map = new LuaMap(lua, -2, size);
                    handler.writer().map(map, new SerializationHint.KeyValueHint((object, writer) -> {
                        lua.pushValue(-2);
                        this.luaToResp(lua, handler);
                    }, (object, writer) -> this.luaToResp(lua, handler)));
                    lua.pop(2);
                    return;
                }
                lua.pop(1);
                lua.push("set");
                lua.rawGet(-2);
                if (lua.type(-1) == Lua.LuaType.TABLE) {
                    lua.push("len");
                    lua.rawGet(-3);
                    int size = (int)lua.toInteger(-1);
                    lua.pop(1);
                    LuaSet set = new LuaSet(lua, -2, size);
                    handler.writer().set(set, (o, writer) -> {
                        lua.pop(1);
                        lua.pushValue(-1);
                        this.luaToResp(lua, handler);
                    });
                    lua.pop(2);
                    return;
                }
                lua.pop(1);
                LuaArray array = new LuaArray(lua, -1);
                handler.writer().array(array, (o, writer) -> this.luaToResp(lua, handler));
                break;
            }
            default: {
                handler.writer().nulls();
            }
        }
        lua.pop(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringField(Lua lua, String name) {
        lua.getField(-1, name);
        try {
            String string = lua.isString(-1) ? lua.toString(-1) : null;
            return string;
        }
        finally {
            lua.pop(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean booleanField(Lua lua, String name) {
        lua.getField(-1, name);
        try {
            boolean bl = lua.isBoolean(-1) && lua.toBoolean(-1);
            return bl;
        }
        finally {
            lua.pop(1);
        }
    }

    private ErrorInfo extractErrorInformation(Lua lua) {
        if (lua.isString(-1)) {
            return new ErrorInfo("ERR " + lua.toString(-1), null, null, false);
        }
        return new ErrorInfo(this.stringField(lua, "err"), this.stringField(lua, "source"), this.stringField(lua, "line"), this.booleanField(lua, "ignore_error_stats_update"));
    }

    static String fName(String sha) {
        return "f_" + sha;
    }

    private void runScript(Lua lua, LuaCode script, String[] keys, String[] args) {
        int i;
        lua.newTable();
        for (i = 0; i < args.length; ++i) {
            lua.push(args[i]);
            lua.rawSetI(-2, i + 1);
        }
        lua.setGlobal("ARGV");
        lua.newTable();
        for (i = 0; i < keys.length; ++i) {
            lua.push(keys[i]);
            lua.rawSetI(-2, i + 1);
        }
        lua.setGlobal("KEYS");
        lua.getGlobal("__redis__err__handler");
        lua.getField(-10000, LuaTaskEngine.fName(script.sha()));
        lua.getLuaNatives().lua_pcall(lua.getPointer(), 0, 1, -2);
    }

    public LuaCode scriptLoad(String script, boolean persistent) {
        Map<String, String> properties = LuaTaskEngine.parseShebang(script, false);
        String sha = LuaContext.sha1hex(script);
        properties.put("sha", sha);
        String name = LuaTaskEngine.scriptName(sha);
        ScriptMetadata.Builder builder = new ScriptMetadata.Builder().name(name).extension("lua").language("lua51").properties(properties);
        ScriptMetadata metadata = builder.build();
        if (persistent) {
            this.scriptingManager.addScript(name, script, metadata);
        }
        return LuaCode.fromScript(script, metadata);
    }

    private static String scriptName(String sha) {
        return "resp_script_" + sha + ".lua";
    }

    public List<Integer> scriptExists(List<String> shas) {
        ArrayList<Integer> exists = new ArrayList<Integer>(shas.size());
        Set names = this.scriptingManager.getScriptNames();
        for (String sha : shas) {
            exists.add(names.contains(LuaTaskEngine.scriptName(sha)) ? 1 : 0);
        }
        return exists;
    }

    public void scriptFlush() {
        Set names = this.scriptingManager.getScriptNames();
        for (String name : names) {
            if (!name.startsWith("resp_script_")) continue;
            this.scriptingManager.removeScript(name);
        }
    }

    private static Map<String, String> parseShebang(String script, boolean required) {
        HashMap<String, String> properties = new HashMap<String, String>();
        long flags = 0L;
        if (script.startsWith("#!")) {
            int end = script.indexOf(10);
            if (end < 0) {
                throw new IllegalArgumentException("Invalid script shebang");
            }
            String[] parts = script.substring(2, end).split(" ");
            String engine = parts[0];
            if (engine.isBlank()) {
                throw new IllegalArgumentException("Invalid library metadata");
            }
            properties.put("engine", engine.toUpperCase());
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i].startsWith("flags=")) {
                    String[] fNames;
                    for (String fName : fNames = parts[i].substring(6).split(",")) {
                        flags |= ScriptFlags.valueOf(fName).value();
                    }
                    continue;
                }
                if (parts[i].startsWith("name=")) {
                    properties.put("name", parts[i].substring(5));
                    continue;
                }
                throw new IllegalArgumentException("Unknown lua shebang option: " + parts[i]);
            }
            if (!properties.containsKey("name") && required) {
                throw new IllegalArgumentException("Library name was not given");
            }
        } else {
            if (required) {
                throw new IllegalArgumentException("Missing library metadata");
            }
            flags = ScriptFlags.EVAL_COMPAT_MODE.value();
        }
        properties.put("flags", Long.toString(flags));
        return properties;
    }

    public String getName() {
        return "resp-lua-engine";
    }

    public List<Task> getTasks() {
        return List.of();
    }

    public <T> CompletionStage<T> runTask(String taskName, TaskContext context, BlockingManager blockingManager) {
        return CompletableFutures.completedNull();
    }

    public boolean handles(String taskName) {
        return false;
    }

    record ErrorInfo(String message, String source, String line, boolean ignoreStatsUpdate) {
    }
}

