/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Commands;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class COMMAND
extends RespCommand
implements Resp3Command {
    public static final String NAME = "COMMAND";
    private static final JavaObjectSerializer<Object> SERIALIZER = (ignore, writer) -> {
        List<RespCommand> commands = Commands.all();
        writer.arrayStart(commands.size());
        for (RespCommand command : commands) {
            writer.arrayNext();
            COMMAND.describeCommand(command, writer);
        }
        writer.arrayEnd();
    };

    public COMMAND() {
        super(NAME, -1, 0, 0, 0);
    }

    @Override
    public long aclMask() {
        return AclCategory.SLOW | AclCategory.CONNECTION;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        if (!arguments.isEmpty()) {
            handler.writer().customError("COMMAND does not currently support arguments");
        } else {
            handler.writer().write(SERIALIZER);
        }
        return handler.myStage();
    }

    private static void describeCommand(RespCommand command, ResponseWriter writer) {
        writer.arrayStart(10);
        writer.arrayNext();
        writer.simpleString(command.getName());
        writer.arrayNext();
        writer.integers(command.getArity());
        writer.arrayNext();
        writer.emptySet();
        writer.arrayNext();
        writer.integers(command.getFirstKeyPos());
        writer.arrayNext();
        writer.integers(command.getLastKeyPos());
        writer.arrayNext();
        writer.integers(command.getSteps());
        writer.arrayNext();
        writer.emptySet();
        writer.arrayNext();
        writer.emptySet();
        writer.arrayNext();
        writer.emptySet();
        writer.arrayNext();
        writer.emptySet();
        writer.arrayEnd();
    }
}

