/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.server.resp.json.JsonLenFunction;
import org.infinispan.util.function.SerializableFunction;

public class JsonLenArrayFunction
extends JsonLenFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Long>> {
    public static final AdvancedExternalizer<JsonLenArrayFunction> EXTERNALIZER = new Externalizer();

    public JsonLenArrayFunction(byte[] path) {
        super(path, JsonNode::isArray, jsonNode -> jsonNode.size());
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonLenArrayFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonLenArrayFunction jsonLenFunction) throws IOException {
            JSONUtil.writeBytes(output, jsonLenFunction.path);
        }

        public JsonLenArrayFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] path = JSONUtil.readBytes(input);
            return new JsonLenArrayFunction(path);
        }

        public Set<Class<? extends JsonLenArrayFunction>> getTypeClasses() {
            return Collections.singleton(JsonLenArrayFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_LEN_ARR_FUNCTION;
        }
    }
}

