/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.time.TimeService;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class TTL
extends RespCommand
implements Resp3Command {
    private final EnumSet<ExpirationOption> options;

    public TTL() {
        this(ExpirationOption.REMAINING, ExpirationOption.SECONDS);
    }

    protected TTL(ExpirationOption ... options) {
        super(2, 1, 1, 1);
        this.options = EnumSet.copyOf(Arrays.asList(options));
    }

    @Override
    public long aclMask() {
        return AclCategory.KEYSPACE | AclCategory.READ | AclCategory.FAST;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] keyBytes = arguments.get(0);
        MediaType vmt = handler.cache().getValueDataConversion().getStorageMediaType();
        return handler.stageToReturn(handler.cache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, vmt).getCacheEntryAsync((Object)keyBytes).thenApply(e -> {
            long ttl;
            if (e == null) {
                return -2L;
            }
            if (e.getLifespan() < 0L) {
                return -1;
            }
            TimeService timeService = handler.respServer().getTimeService();
            long l = ttl = this.options.contains((Object)ExpirationOption.REMAINING) ? e.getLifespan() - (timeService.wallClockTime() - e.getCreated()) : e.getLifespan();
            if (this.options.contains((Object)ExpirationOption.UNIX_TIME)) {
                ttl = RespUtil.toUnixTime(ttl, timeService);
            }
            if (this.options.contains((Object)ExpirationOption.SECONDS)) {
                ttl /= 1000L;
            }
            return ttl;
        }), ctx, ResponseWriter.INTEGER);
    }

    protected static enum ExpirationOption {
        REMAINING,
        UNIX_TIME,
        SECONDS;

    }
}

