/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.server.resp.json.JsonLenFunction;
import org.infinispan.util.function.SerializableFunction;

public class JsonLenObjFunction
extends JsonLenFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Long>> {
    public static final AdvancedExternalizer<JsonLenObjFunction> EXTERNALIZER = new Externalizer();

    public JsonLenObjFunction(byte[] path) {
        super(path, JsonNode::isObject, jsonNode -> jsonNode.size());
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonLenObjFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonLenObjFunction jsonLenFunction) throws IOException {
            JSONUtil.writeBytes(output, jsonLenFunction.path);
        }

        public JsonLenObjFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] path = JSONUtil.readBytes(input);
            return new JsonLenObjFunction(path);
        }

        public Set<Class<? extends JsonLenObjFunction>> getTypeClasses() {
            return Collections.singleton(JsonLenObjFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_LEN_OBJ_FUNCTION;
        }
    }
}

