/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.ServerException;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers$;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedDecoder$;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.TextProtocolUtil$class;
import org.infinispan.stats.Stats;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t-e\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003!5+WnY1dQ\u0016$G)Z2pI\u0016\u0014(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002I\u0012\u0011\t5\u0001\"\u0003H\u0007\u0002\u001d)\u0011q\u0002B\u0001\u0005G>\u0014X-\u0003\u0002\u0012\u001d\t9\u0012IY:ue\u0006\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c#fG>$WM\u001d\t\u0003'eq!\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\ta\u0001\u0015:fI\u00164\u0017B\u0001\u000e\u001c\u0005\u0019\u0019FO]5oO*\u0011\u0001$\u0006\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011a\"T3nG\u0006\u001c\u0007.\u001a3WC2,X\r\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0011)\u0016DH\u000f\u0015:pi>\u001cw\u000e\\+uS2\u0004\"\u0001\u0006\u0013\n\u0005\u0015*\"aC*dC2\fwJ\u00196fGRD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0005S)\u0012B$D\u0001\u0007\u0013\tYcAA\u0003DC\u000eDW\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003%\u00198\r[3ek2,'\u000f\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005M\"\u0014\u0001B;uS2T\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028a\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\rYD(\u0010\t\u0003;\u0001AQa\n\u001dA\u0002!BQ!\f\u001dA\u00029*\u0001b\u0010\u0001\u0005\u0002\u0003\u0005\t\u0001\u0011\u0002\u0013'VLG/\u00192mKB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0002\u001e\u0003&\u0011!I\u0001\u0002\u0014\u001b\u0016l7-Y2iK\u0012\u0004\u0016M]1nKR,'o]\u0003\t\t\u0002!\t\u0011!A\u0001\u000b\nq1+^5uC\ndW\rS3bI\u0016\u0014\bCA\u0007G\u0013\t9eBA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\t\u0013\u0002A)\u0019!C\u0005\u0015\u0006q\u0011n]*uCR\u001cXI\\1cY\u0016$W#A&\u0011\u0005Qa\u0015BA'\u0016\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0014\u0001\t\u0002\u0003\u0006KaS\u0001\u0010SN\u001cF/\u0019;t\u000b:\f'\r\\3eA!9\u0011\u000b\u0001b\u0001\n\u001b\u0011\u0016AC5oGJl\u0015n]:fgV\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002Wa\u00051\u0011\r^8nS\u000eL!\u0001W+\u0003\u0015\u0005#x.\\5d\u0019>tw\r\u0003\u0004[\u0001\u0001\u0006iaU\u0001\fS:\u001c'/T5tg\u0016\u001c\b\u0005C\u0004]\u0001\t\u0007IQ\u0002*\u0002\u0011%t7M\u001d%jiNDaA\u0018\u0001!\u0002\u001b\u0019\u0016!C5oGJD\u0015\u000e^:!\u0011\u001d\u0001\u0007A1A\u0005\u000eI\u000b!\u0002Z3de6K7o]3t\u0011\u0019\u0011\u0007\u0001)A\u0007'\u0006YA-Z2s\u001b&\u001c8/Z:!\u0011\u001d!\u0007A1A\u0005\u000eI\u000b\u0001\u0002Z3de\"KGo\u001d\u0005\u0007M\u0002\u0001\u000bQB*\u0002\u0013\u0011,7M\u001d%jiN\u0004\u0003b\u00025\u0001\u0005\u0004%iAU\u0001\u001ae\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\rZ'jgN,7\u000f\u0003\u0004k\u0001\u0001\u0006iaU\u0001\u001be\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\rZ'jgN,7\u000f\t\u0005\bY\u0002\u0011\r\u0011\"\u0004S\u0003]\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0011&$8\u000f\u0003\u0004o\u0001\u0001\u0006iaU\u0001\u0019e\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\r\u001a%jiN\u0004\u0003b\u00029\u0001\u0005\u0004%iAU\u0001\u001ae\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\r\u001a\"bIZ\fG\u000e\u0003\u0004s\u0001\u0001\u0006iaU\u0001\u001be\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\r\u001a\"bIZ\fG\u000e\t\u0005\u0006i\u0002!\t%^\u0001\u000be\u0016\fG\rS3bI\u0016\u0014HCA#w\u0011\u001598\u000f1\u0001y\u0003\u0019\u0011WO\u001a4feB\u0011\u0011\u0010`\u0007\u0002u*\u00111PD\u0001\niJ\fgn\u001d9peRL!! >\u0003\u001b\rC\u0017M\u001c8fY\n+hMZ3s\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u00059!/Z1e\u0017\u0016LH#\u0002\n\u0002\u0004\u0005\u001d\u0001BBA\u0003}\u0002\u0007Q)A\u0001i\u0011\u0019\tIA a\u0001q\u0006\t!\rC\u0004\u0002\u000e\u0001!I!a\u0004\u0002\u0011I,\u0017\rZ&fsN$b!!\u0005\u0002\u0018\u0005e\u0001\u0003\u0002\u000b\u0002\u0014II1!!\u0006\u0016\u0005\u0015\t%O]1z\u0011\u001d\t)!a\u0003A\u0002\u0015Cq!!\u0003\u0002\f\u0001\u0007\u0001\u0010C\u0004\u0002\u001e\u0001!\t&a\b\u0002\u0007\u001d,G\u000f\u0006\u0005\u0002\"\u0005\u001d\u0012\u0011FA\u0016!\r!\u00121E\u0005\u0004\u0003K)\"AB!osJ+g\rC\u0004\u0002\u0006\u0005m\u0001\u0019A#\t\r]\fY\u00021\u0001y\u0011\u00199\u00131\u0004a\u0001Q!9\u0011q\u0006\u0001\u0005B\u0005E\u0012A\u0004:fC\u0012\u0004\u0016M]1nKR,'o\u001d\u000b\u0007\u0003g\tI$a\u000f\u0011\tQ\t)\u0004Q\u0005\u0004\u0003o)\"AB(qi&|g\u000eC\u0004\u0002\u0006\u00055\u0002\u0019A#\t\u000f\u0005%\u0011Q\u0006a\u0001q\"9\u0011q\b\u0001\u0005B\u0005\u0005\u0013aC2sK\u0006$XMV1mk\u0016$r\u0001HA\"\u0003\u0013\ni\u0005\u0003\u0005\u0002\u0006\u0005u\u0002\u0019AA#!\r\t9eQ\u0007\u0002\u0001!9\u00111JA\u001f\u0001\u0004\u0001\u0015!\u00019\t\u0011\u0005=\u0013Q\ba\u0001\u0003#\n1B\\3yiZ+'o]5p]B\u0019A#a\u0015\n\u0007\u0005USC\u0001\u0003M_:<\u0007bBA-\u0001\u0011%\u00111L\u0001\tO\u0016$h\t\\1hgR!\u0011QLA2!\r!\u0012qL\u0005\u0004\u0003C*\"aA%oi\"9\u0011QMA,\u0001\u0004\u0011\u0012!\u00024mC\u001e\u001c\bbBA5\u0001\u0011%\u00111N\u0001\fO\u0016$H*\u001b4fgB\fg\u000e\u0006\u0003\u0002^\u00055\u0004bBA8\u0003O\u0002\rAE\u0001\tY&4Wm\u001d9b]\"9\u00111\u000f\u0001\u0005\n\u0005U\u0014!C4fi2+gn\u001a;i)\u0011\ti&a\u001e\t\u000f\u0005e\u0014\u0011\u000fa\u0001%\u00051A.\u001a8hi\"Dq!! \u0001\t\u0013\ty(\u0001\u0006hKR4VM]:j_:$B!!\u0015\u0002\u0002\"9\u00111QA>\u0001\u0004\u0011\u0012a\u0002<feNLwN\u001c\u0005\b\u0003\u000f\u0003A\u0011BAE\u00031\u0001\u0018M]:f\u001d>\u0014V\r\u001d7z)\u0015Y\u00151RAH\u0011!\ti)!\"A\u0002\u0005u\u0013!D3ya\u0016\u001cG/\u001a3J]\u0012,\u0007\u0010\u0003\u0005\u0002\u0012\u0006\u0015\u0005\u0019AA\t\u0003\u0011\t'oZ:\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\u00061\u0002/\u0019:tK\u0012+G.Y=fI\u0012+G.\u001a;f)&lW\r\u0006\u0004\u0002^\u0005e\u00151\u0014\u0005\t\u0003\u001b\u000b\u0019\n1\u0001\u0002^!A\u0011\u0011SAJ\u0001\u0004\t\t\u0002C\u0004\u0002 \u0002!\t%!)\u0002\u0011\u001d,GoQ1dQ\u0016$2\u0001KAR\u0011\u001d\t)!!(A\u0002\u0015Cq!a*\u0001\t\u0003\nI+A\niC:$G.Z\"vgR|WNU3rk\u0016\u001cH\u000f\u0006\u0005\u0002\"\u0005-\u0016QVAX\u0011\u001d\t)!!*A\u0002\u0015Cq!!\u0003\u0002&\u0002\u0007\u0001\u0010\u0003\u0004(\u0003K\u0003\r\u0001\u000b\u0005\b\u0003g\u0003A\u0011IA[\u0003U\u0019'/Z1uKN+8mY3tgJ+7\u000f]8og\u0016$\u0002\"!\t\u00028\u0006e\u0016Q\u0018\u0005\b\u0003\u000b\t\t\f1\u0001F\u0011!\tY,!-A\u0002\u0005M\u0012A\u00029be\u0006l7\u000fC\u0004\u0002@\u0006E\u0006\u0019\u0001\u000f\u0002\tA\u0014XM\u001e\u0005\b\u0003\u0007\u0004A\u0011IAc\u0003e\u0019'/Z1uK:{G/\u0012=fGV$X\r\u001a*fgB|gn]3\u0015\u0011\u0005\u0005\u0012qYAe\u0003\u0017Dq!!\u0002\u0002B\u0002\u0007Q\t\u0003\u0005\u0002<\u0006\u0005\u0007\u0019AA\u001a\u0011\u001d\ty,!1A\u0002qAq!a4\u0001\t\u0003\n\t.\u0001\fde\u0016\fG/\u001a(pi\u0016C\u0018n\u001d;SKN\u0004xN\\:f)\u0019\t\t#a5\u0002V\"A\u0011QAAg\u0001\u0004\t)\u0005\u0003\u0005\u0002<\u00065\u0007\u0019AA\u001a\u0011\u001d\tI\u000e\u0001C!\u00037\f\u0011c\u0019:fCR,w)\u001a;SKN\u0004xN\\:f)!\t\t#!8\u0002`\u0006\r\bbBA\u0003\u0003/\u0004\r!\u0012\u0005\b\u0003C\f9\u000e1\u0001\u0013\u0003\u0005Y\u0007bBAs\u0003/\u0004\r\u0001H\u0001\u0002m\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\u0018AF2sK\u0006$X-T;mi&<U\r\u001e*fgB|gn]3\u0015\r\u0005\u0005\u0012Q^Ax\u0011\u001d\t)!a:A\u0002\u0015C\u0001\"!=\u0002h\u0002\u0007\u00111_\u0001\u0006a\u0006L'o\u001d\t\u0006'\u0005U(\u0003H\u0005\u0004\u0003o\\\"aA'ba\"9\u00111 \u0001\u0005B\u0005u\u0018aE2sK\u0006$X-\u0012:s_J\u0014Vm\u001d9p]N,G\u0003BA\u0011\u0003\u007fD\u0001B!\u0001\u0002z\u0002\u0007!1A\u0001\u0002iB!!Q\u0001B\u000b\u001d\u0011\u00119A!\u0005\u000f\t\t%!qB\u0007\u0003\u0005\u0017Q1A!\u0004\u000b\u0003\u0019a$o\\8u}%\ta#C\u0002\u0003\u0014U\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0018\te!!\u0003+ie><\u0018M\u00197f\u0015\r\u0011\u0019\"\u0006\u0005\b\u0005;\u0001A\u0011\u0001B\u0010\u0003M\u0019'/Z1uKN#\u0018\r^:SKN\u0004xN\\:f)\u0019\t\tC!\t\u0003&!9!1\u0005B\u000e\u0001\u0004)\u0015A\u00025fC\u0012,'\u000f\u0003\u0005\u0003(\tm\u0001\u0019\u0001B\u0015\u0003\u0015\u0019H/\u0019;t!\u0011\u0011YCa\f\u000e\u0005\t5\"b\u0001B\u0014\r%!!\u0011\u0007B\u0017\u0005\u0015\u0019F/\u0019;t\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005o\t\u0011BY;jY\u0012\u001cF/\u0019;\u0015\u000fa\u0014ID!\u0010\u0003H!9!1\bB\u001a\u0001\u0004\u0011\u0012\u0001B:uCRD\u0001Ba\u0010\u00034\u0001\u0007!\u0011I\u0001\u0006m\u0006dW/\u001a\t\u0004)\t\r\u0013b\u0001B#+\t\u0019\u0011I\\=\t\u0011\t%#1\u0007a\u0001\u0005\u0017\n!a\u001d2\u0011\t\t\u0015!QJ\u0005\u0005\u0005\u001f\u0012IBA\u0007TiJLgn\u001a\"vS2$WM\u001d\u0005\b\u0003\u007f\u0001A\u0011\u0002B*)\u001da\"Q\u000bB1\u0005GB\u0001Ba\u0016\u0003R\u0001\u0007!\u0011L\u0001\u0005I\u0006$\u0018\rE\u0003\u0015\u0003'\u0011Y\u0006E\u0002\u0015\u0005;J1Aa\u0018\u0016\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005=#\u0011\u000ba\u0001\u0003#B\u0001\"!\u001a\u0003R\u0001\u0007\u0011Q\f\u0005\b\u0005O\u0002A\u0011\u0002B5\u0003A\u0011W/\u001b7e\u000f\u0016$(+Z:q_:\u001cX\rF\u0004y\u0005W\u0012YH! \t\u0011\t5$Q\ra\u0001\u0005_\n!a\u001c9\u0011\t\tE$q\u000f\t\u0004)\tM\u0014b\u0001B;+\tYQI\\;nKJ\fG/[8o\u0013\u0011\u0011IHa\u001d\u0003\u000bY\u000bG.^3\t\u000f\u0005\u0005(Q\ra\u0001%!9\u0011Q\u001dB3\u0001\u0004a\u0002b\u0002BA\u0001\u0011%!1Q\u0001\u0017EVLG\u000eZ$fiJ+7\u000f]8og\u0016DU-\u00193feR9!C!\"\u0003\b\n%\u0005bBAq\u0005\u007f\u0002\rA\u0005\u0005\b\u0003K\u0014y\b1\u0001\u001d\u0011!\u0011iGa A\u0002\t=\u0004")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements TextProtocolUtil,
ScalaObject {
    private final Cache<String, MemcachedValue> cache;
    private final ScheduledExecutorService scheduler;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final String CRLF;
    private final byte[] CRLFBytes;
    private final byte[] END;
    private final byte[] DELETED;
    private final byte[] NOT_FOUND;
    private final byte[] EXISTS;
    private final byte[] STORED;
    private final byte[] NOT_STORED;
    private final byte[] OK;
    private final byte[] ERROR;
    private final int CR;
    private final int LF;
    public volatile int bitmap$0;

    @Override
    public String CRLF() {
        return this.CRLF;
    }

    @Override
    public byte[] CRLFBytes() {
        return this.CRLFBytes;
    }

    @Override
    public byte[] END() {
        return this.END;
    }

    @Override
    public byte[] DELETED() {
        return this.DELETED;
    }

    @Override
    public byte[] NOT_FOUND() {
        return this.NOT_FOUND;
    }

    @Override
    public byte[] EXISTS() {
        return this.EXISTS;
    }

    @Override
    public byte[] STORED() {
        return this.STORED;
    }

    @Override
    public byte[] NOT_STORED() {
        return this.NOT_STORED;
    }

    @Override
    public byte[] OK() {
        return this.OK;
    }

    @Override
    public byte[] ERROR() {
        return this.ERROR;
    }

    @Override
    public int CR() {
        return this.CR;
    }

    @Override
    public int LF() {
        return this.LF;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLF_$eq(String string) {
        this.CRLF = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLFBytes_$eq(byte[] byArray) {
        this.CRLFBytes = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$END_$eq(byte[] byArray) {
        this.END = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$DELETED_$eq(byte[] byArray) {
        this.DELETED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_FOUND_$eq(byte[] byArray) {
        this.NOT_FOUND = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$EXISTS_$eq(byte[] byArray) {
        this.EXISTS = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$STORED_$eq(byte[] byArray) {
        this.STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_STORED_$eq(byte[] byArray) {
        this.NOT_STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$OK_$eq(byte[] byArray) {
        this.OK = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$ERROR_$eq(byte[] byArray) {
        this.ERROR = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CR_$eq(int n) {
        this.CR = n;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$LF_$eq(int n) {
        this.LF = n;
    }

    @Override
    public String readElement(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readElement(this, buffer);
    }

    @Override
    public String readLine(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readLine(this, buffer);
    }

    @Override
    public byte[] concat(byte[] a, byte[] b) {
        return TextProtocolUtil$class.concat(this, a, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$0 & 1) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$0 & 1) == 0) {
                this.isStatsEnabled = this.cache.getConfiguration().isExposeJmxStatistics();
                this.bitmap$0 |= 1;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    public RequestHeader readHeader(ChannelBuffer buffer) {
        Option<Enumeration.Value> op;
        String streamOp = this.readElement(buffer);
        Option<Enumeration.Value> option = op = RequestResolver$.MODULE$.toRequest(streamOp);
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            String line = this.readLine(buffer);
            throw new UnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)streamOp).toString());
        }
        return new RequestHeader((Enumeration.Value)op.get());
    }

    public String readKey(RequestHeader h, ChannelBuffer b) {
        return this.readElement(b);
    }

    private String[] readKeys(RequestHeader h, ChannelBuffer b) {
        String line = this.readLine(b);
        return line.trim().split(" +");
    }

    public Object get(RequestHeader h, ChannelBuffer buffer, Cache<String, MemcachedValue> cache$1) {
        Object object;
        String[] keys = this.readKeys(h, buffer);
        if (keys.length > 1) {
            scala.collection.mutable.HashMap map$1 = new scala.collection.mutable.HashMap();
            Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new $anonfun$get$1(this, cache$1, map$1));
            object = this.createMultiGetResponse(h, (Map<String, MemcachedValue>)new HashMap().$plus$plus((TraversableOnce)map$1));
        } else {
            object = this.createGetResponse(h, (String)Predef$.MODULE$.refArrayOps((Object[])keys).head(), (MemcachedValue)((Object)cache$1.get(Predef$.MODULE$.refArrayOps((Object[])keys).head())));
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<MemcachedParameters> readParameters(RequestHeader h, ChannelBuffer b) {
        Enumeration.Value value;
        Enumeration.Value value2;
        int index;
        String[] args;
        None$ none$;
        block8: {
            block7: {
                String line = this.readLine(b);
                if (line.isEmpty()) {
                    none$ = None$.MODULE$;
                    return none$;
                }
                if (RequestResolver$.MODULE$.isTraceEnabled()) {
                    RequestResolver$.MODULE$.trace((Function0)new $anonfun$readParameters$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line}));
                }
                args = line.trim().split(" +");
                index = 0;
                Enumeration.Value value3 = value2 = h.op();
                Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    int delayedDeleteTime = this.parseDelayedDeleteTime(index, args);
                    boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(index, args) : false;
                    none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, noReply, 0, "", 0));
                    return none$;
                }
                Enumeration.Value value5 = value2;
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                if (!(value5 == null ? value6 != null : !value5.equals(value6))) break block7;
                Enumeration.Value value7 = value2;
                Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                if (value7 != null ? !value7.equals(value8) : value8 != null) break block8;
            }
            String delta = args[index];
            none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, this.parseNoReply(++index, args), 0, delta, 0));
            return none$;
        }
        Enumeration.Value value9 = value2;
        Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
        if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
            int flushDelay = Predef$.MODULE$.augmentString(args[index]).toInt();
            none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, this.parseNoReply(++index, args), 0, "", flushDelay));
            return none$;
        }
        int flags = this.getFlags(args[index]);
        int streamLifespan = this.getLifespan(args[++index]);
        int lifespan = streamLifespan <= 0 ? -1 : streamLifespan;
        int length = this.getLength(args[++index]);
        Enumeration.Value value11 = value = h.op();
        Enumeration.Value value12 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        long streamVersion = !(value11 != null ? !value11.equals(value12) : value12 != null) ? this.getVersion(args[++index]) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        byte[] data = new byte[length];
        b.readBytes(data, 0, data.length);
        this.readLine(b);
        none$ = new Some((Object)new MemcachedParameters(data, lifespan, -1, streamVersion, noReply, flags, "", 0));
        return none$;
    }

    public MemcachedValue createValue(RequestHeader h, MemcachedParameters p, long nextVersion) {
        return new MemcachedValue(p.data(), nextVersion, p.flags());
    }

    private int getFlags(String flags) {
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        return Predef$.MODULE$.augmentString(flags).toInt();
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return Predef$.MODULE$.augmentString(lifespan).toInt();
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return Predef$.MODULE$.augmentString(length).toInt();
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, String[] args) {
        if (args.length <= expectedIndex) return false;
        String string = args[expectedIndex];
        if ("noreply" != null) {
            if (!"noreply".equals(string)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (string == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(int expectedIndex, String[] args) {
        int n;
        if (args.length <= expectedIndex) return 0;
        int exceptionResult1 = 0;
        try {
            n = exceptionResult1 = Predef$.MODULE$.augmentString(args[expectedIndex]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache(RequestHeader h) {
        return this.cache;
    }

    public Object handleCustomRequest(RequestHeader h, ChannelBuffer b, Cache<String, MemcachedValue> cache) {
        Enumeration.Value value;
        block22: {
            Object object;
            block10: {
                block21: {
                    block15: {
                        Enumeration.Value value2;
                        block19: {
                            BigInt prevCounter;
                            block20: {
                                Object object2;
                                Object object3;
                                MemcachedValue prev;
                                Option<MemcachedParameters> params;
                                String k;
                                block18: {
                                    block17: {
                                        block16: {
                                            Object object4;
                                            block14: {
                                                block8: {
                                                    Enumeration.Value value3;
                                                    block13: {
                                                        byte[] byArray;
                                                        MemcachedValue prev2;
                                                        Option<MemcachedParameters> params2;
                                                        String k2;
                                                        block12: {
                                                            block11: {
                                                                block9: {
                                                                    block7: {
                                                                        Enumeration.Value value4 = value = h.op();
                                                                        Enumeration.Value value5 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                        if (!(value4 == null ? value5 != null : !value4.equals(value5))) break block7;
                                                                        Enumeration.Value value6 = value;
                                                                        Enumeration.Value value7 = MemcachedOperation$.MODULE$.PrependRequest();
                                                                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block8;
                                                                    }
                                                                    k2 = this.readKey(h, b);
                                                                    params2 = this.readParameters(h, b);
                                                                    prev2 = (MemcachedValue)((Object)cache.get(k2));
                                                                    if (prev2 != null) break block9;
                                                                    object = ((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED();
                                                                    break block10;
                                                                }
                                                                Enumeration.Value value8 = value3 = h.op();
                                                                Enumeration.Value value9 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block11;
                                                                byArray = this.concat(prev2.data(), ((MemcachedParameters)((Object)params2.get())).data());
                                                                break block12;
                                                            }
                                                            Enumeration.Value value10 = value3;
                                                            Enumeration.Value value11 = MemcachedOperation$.MODULE$.PrependRequest();
                                                            if (value10 != null ? !value10.equals(value11) : value11 != null) break block13;
                                                            byArray = this.concat(((MemcachedParameters)((Object)params2.get())).data(), prev2.data());
                                                        }
                                                        byte[] concatenated = byArray;
                                                        MemcachedValue next = this.createValue(concatenated, this.generateVersion(cache), ((MemcachedParameters)((Object)params2.get())).flags());
                                                        boolean replaced = cache.replace(k2, prev2, next);
                                                        object = replaced ? (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.STORED()) : (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED());
                                                        break block10;
                                                    }
                                                    throw new MatchError((Object)value3);
                                                }
                                                Enumeration.Value value12 = value;
                                                Enumeration.Value value13 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                if (!(value12 == null ? value13 != null : !value12.equals(value13))) break block14;
                                                Enumeration.Value value14 = value;
                                                Enumeration.Value value15 = MemcachedOperation$.MODULE$.DecrementRequest();
                                                if (value14 != null ? !value14.equals(value15) : value15 != null) break block15;
                                            }
                                            k = this.readKey(h, b);
                                            params = this.readParameters(h, b);
                                            prev = (MemcachedValue)((Object)cache.get(k));
                                            if (prev != null) break block16;
                                            if (this.isStatsEnabled()) {
                                                Enumeration.Value value16 = h.op();
                                                Enumeration.Value value17 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                object4 = BoxesRunTime.boxToLong((long)(!(value16 != null ? !value16.equals(value17) : value17 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                            } else {
                                                object4 = BoxedUnit.UNIT;
                                            }
                                            object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND();
                                            break block10;
                                        }
                                        prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                                        Enumeration.Value value18 = value2 = h.op();
                                        Enumeration.Value value19 = MemcachedOperation$.MODULE$.IncrementRequest();
                                        if (value18 != null ? !value18.equals(value19) : value19 != null) break block17;
                                        BigInt candidateCounter = prevCounter.$plus(package$.MODULE$.BigInt().apply(((MemcachedParameters)((Object)params.get())).delta()));
                                        object3 = candidateCounter.$greater(package$.MODULE$.BigInt().apply("18446744073709551615")) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                                        break block18;
                                    }
                                    Enumeration.Value value20 = value2;
                                    Enumeration.Value value21 = MemcachedOperation$.MODULE$.DecrementRequest();
                                    if (value20 != null ? !value20.equals(value21) : value21 != null) break block19;
                                    BigInt candidateCounter = prevCounter.$minus(package$.MODULE$.BigInt().apply(((MemcachedParameters)((Object)params.get())).delta()));
                                    object3 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                                }
                                Object newCounter = object3;
                                MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion(cache), ((MemcachedParameters)((Object)params.get())).flags());
                                boolean replaced = cache.replace(k, prev, next);
                                if (!replaced) break block20;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value22 = h.op();
                                    Enumeration.Value value23 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object2 = BoxesRunTime.boxToLong((long)(!(value22 != null ? !value22.equals(value23) : value23 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                                } else {
                                    object2 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next.data())).append((Object)this.CRLF()).toString();
                                break block10;
                            }
                            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
                        }
                        throw new MatchError((Object)value2);
                    }
                    Enumeration.Value value24 = value;
                    Enumeration.Value value25 = MemcachedOperation$.MODULE$.FlushAllRequest();
                    if (value24 != null ? !value24.equals(value25) : value25 != null) break block21;
                    Option<MemcachedParameters> params = this.readParameters(h, b);
                    $anonfun$1 flushFunction = new $anonfun$1(this);
                    Option<MemcachedParameters> option = params;
                    None$ none$ = None$.MODULE$;
                    int flushDelay = !(option != null ? !option.equals((Object)none$) : none$ != null) ? 0 : ((MemcachedParameters)((Object)params.get())).flushDelay();
                    ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply(cache.getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll(cache, (Function1<AdvancedCache<String, MemcachedValue>, Object>)flushFunction), (long)flushDelay, TimeUnit.SECONDS);
                    Option<MemcachedParameters> option2 = params;
                    None$ none$2 = None$.MODULE$;
                    object = (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.OK();
                    break block10;
                }
                Enumeration.Value value26 = value;
                Enumeration.Value value27 = MemcachedOperation$.MODULE$.VersionRequest();
                if (value26 != null ? !value26.equals(value27) : value27 != null) break block22;
                object = new StringBuilder().append("VERSION ").append("4.2.0.SNAPSHOT").append(this.CRLF());
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object createSuccessResponse(RequestHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value;
            Enumeration.Value value4 = value = h.op();
            Enumeration.Value value5 = Operation$.MODULE$.RemoveRequest();
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.DELETED() : this.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(RequestHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value;
            Enumeration.Value value4 = value = h.op();
            Enumeration.Value value5 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.EXISTS() : this.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse(RequestHeader h, Option<MemcachedParameters> params) {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        return (byte[])((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND());
    }

    public Object createGetResponse(RequestHeader h, String k, MemcachedValue v) {
        return v == null ? this.END() : (byte[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(h.op(), k, v), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    public Object createMultiGetResponse(RequestHeader h$1, Map<String, MemcachedValue> pairs) {
        Enumeration.Value value;
        block3: {
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                Enumeration.Value value2 = value = h$1.op();
                Enumeration.Value value3 = Operation$.MODULE$.GetRequest();
                if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                Enumeration.Value value4 = value;
                Enumeration.Value value5 = Operation$.MODULE$.GetWithVersionRequest();
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block3;
            }
            pairs.foreach((Function1)new $anonfun$createMultiGetResponse$1(this, h$1, elements$1));
            elements$1.$plus$eq((Object)ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{"END\r\n".getBytes()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        StringBuilder sb = new StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof ServerException) {
            ServerException serverException = (ServerException)throwable;
            ServerException se = serverException;
            Throwable throwable2 = se.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                object = this.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                object = null;
            } else {
                Throwable throwable3 = t;
                StringBuilder stringBuilder = throwable3 instanceof IOException ? sb.append("CLIENT_ERROR ") : sb.append("SERVER_ERROR ");
                object = sb.append((Object)t).append(this.CRLF());
            }
        } else {
            object = throwable instanceof ClosedChannelException ? null : sb.append("SERVER_ERROR ").append((Object)t).append(this.CRLF());
        }
        return object;
    }

    public Object createStatsResponse(RequestHeader header, Stats stats) {
        StringBuilder sb = new StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache.getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("bytes_written", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(this.CRLF());
        ChannelBuffer buffer = ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, int flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        String header = this.buildGetResponseHeader(k, v, op);
        return ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{header.getBytes(), v.data(), this.CRLFBytes()}));
    }

    private String buildGetResponseHeader(String k, MemcachedValue v, Enumeration.Value op) {
        StringBuilder sb = new StringBuilder();
        sb.append("VALUE ").append(k).append(" ").append(v.flags()).append(" ").append(v.data().length);
        Enumeration.Value value = op;
        Enumeration.Value value2 = Operation$.MODULE$.GetWithVersionRequest();
        Object object = !(value != null ? !value.equals(value2) : value2 != null) ? sb.append(" ").append(v.version()) : BoxedUnit.UNIT;
        sb.append(this.CRLF());
        return sb.toString();
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> cache, ScheduledExecutorService scheduler) {
        this.cache = cache;
        this.scheduler = scheduler;
        TextProtocolUtil$class.$init$(this);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
    }
}

