/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.manager.CacheManager;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.ServerException;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers$;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedDecoder$;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.TextProtocolUtil$class;
import org.infinispan.stats.Stats;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\tee\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003!5+WnY1dQ\u0016$G)Z2pI\u0016\u0014(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002I\u0012\u0011\t5\u0001\"\u0003H\u0007\u0002\u001d)\u0011q\u0002B\u0001\u0005G>\u0014X-\u0003\u0002\u0012\u001d\t9\u0012IY:ue\u0006\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c#fG>$WM\u001d\t\u0003'eq!\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\ta\u0001\u0015:fI\u00164\u0017B\u0001\u000e\u001c\u0005\u0019\u0019FO]5oO*\u0011\u0001$\u0006\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011a\"T3nG\u0006\u001c\u0007.\u001a3WC2,X\r\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0011)\u0016DH\u000f\u0015:pi>\u001cw\u000e\\+uS2\u0004\"\u0001\u0006\u0013\n\u0005\u0015*\"aC*dC2\fwJ\u00196fGRD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\rG\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0019\tq!\\1oC\u001e,'/\u0003\u0002.U\ta1)Y2iK6\u000bg.Y4fe\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005tG\",G-\u001e7feB\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\u000bG>t7-\u001e:sK:$(BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0003]\nAA[1wC&\u0011\u0011H\r\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\bF\u0002>}}\u0002\"!\b\u0001\t\u000b\u001dR\u0004\u0019\u0001\u0015\t\u000b=R\u0004\u0019\u0001\u0019\u0006\u0011\u0005\u0003A\u0011!A\u0001\u0002\t\u0013!cU;ji\u0006\u0014G.\u001a)be\u0006lW\r^3sgB\u0011QdQ\u0005\u0003\t\n\u00111#T3nG\u0006\u001c\u0007.\u001a3QCJ\fW.\u001a;feN,\u0001B\u0012\u0001\u0005\u0002\u0003\u0005\ta\u0012\u0002\u000f'VLG/\u00192mK\"+\u0017\rZ3s!\ti\u0001*\u0003\u0002J\u001d\ti!+Z9vKN$\b*Z1eKJD\u0001b\u0013\u0001\t\u0006\u0004%I\u0001T\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002\u001bB!aj\u0014\n\u001d\u001b\u00051\u0011B\u0001)\u0007\u0005\u0015\u0019\u0015m\u00195f\u0011!\u0011\u0006\u0001#A!B\u0013i\u0015AB2bG\",\u0007\u0005\u0003\u0005U\u0001!\u0015\r\u0011\"\u0003V\u00039I7o\u0015;biN,e.\u00192mK\u0012,\u0012A\u0016\t\u0003)]K!\u0001W\u000b\u0003\u000f\t{w\u000e\\3b]\"A!\f\u0001E\u0001B\u0003&a+A\bjgN#\u0018\r^:F]\u0006\u0014G.\u001a3!\u0011\u001da\u0006A1A\u0005\u000eu\u000b!\"\u001b8de6K7o]3t+\u0005q\u0006CA0c\u001b\u0005\u0001'BA13\u0003\u0019\tGo\\7jG&\u00111\r\u0019\u0002\u000b\u0003R|W.[2M_:<\u0007BB3\u0001A\u00035a,A\u0006j]\u000e\u0014X*[:tKN\u0004\u0003bB4\u0001\u0005\u0004%i!X\u0001\tS:\u001c'\u000fS5ug\"1\u0011\u000e\u0001Q\u0001\u000ey\u000b\u0011\"\u001b8de\"KGo\u001d\u0011\t\u000f-\u0004!\u0019!C\u0007;\u0006QA-Z2s\u001b&\u001c8/Z:\t\r5\u0004\u0001\u0015!\u0004_\u0003-!Wm\u0019:NSN\u001cXm\u001d\u0011\t\u000f=\u0004!\u0019!C\u0007;\u0006AA-Z2s\u0011&$8\u000f\u0003\u0004r\u0001\u0001\u0006iAX\u0001\nI\u0016\u001c'\u000fS5ug\u0002Bqa\u001d\u0001C\u0002\u00135Q,A\rsKBd\u0017mY3JMVsWn\u001c3jM&,G-T5tg\u0016\u001c\bBB;\u0001A\u00035a,\u0001\u000esKBd\u0017mY3JMVsWn\u001c3jM&,G-T5tg\u0016\u001c\b\u0005C\u0004x\u0001\t\u0007IQB/\u0002/I,\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3ISR\u001c\bBB=\u0001A\u00035a,\u0001\rsKBd\u0017mY3JMVsWn\u001c3jM&,G\rS5ug\u0002Bqa\u001f\u0001C\u0002\u00135Q,A\rsKBd\u0017mY3JMVsWn\u001c3jM&,GMQ1em\u0006d\u0007BB?\u0001A\u00035a,\u0001\u000esKBd\u0017mY3JMVsWn\u001c3jM&,GMQ1em\u0006d\u0007\u0005\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011A\u0001\u000be\u0016\fG\rS3bI\u0016\u0014HcA$\u0002\u0004!9\u0011Q\u0001@A\u0002\u0005\u001d\u0011A\u00022vM\u001a,'\u000f\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAD\u0001\niJ\fgn\u001d9peRLA!!\u0005\u0002\f\ti1\t[1o]\u0016d')\u001e4gKJDq!!\u0006\u0001\t\u0003\n9\"A\u0004sK\u0006$7*Z=\u0015\u000bI\tI\"!\b\t\u000f\u0005m\u00111\u0003a\u0001\u000f\u0006\t\u0001\u000e\u0003\u0005\u0002 \u0005M\u0001\u0019AA\u0004\u0003\u0005\u0011\u0007bBA\u0012\u0001\u0011\u0005\u0013QE\u0001\te\u0016\fGmS3zgR1\u0011qEA\u0017\u0003_\u0001B\u0001FA\u0015%%\u0019\u00111F\u000b\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005m\u0011\u0011\u0005a\u0001\u000f\"A\u0011qDA\u0011\u0001\u0004\t9\u0001C\u0004\u00024\u0001!\t%!\u000e\u0002\u001dI,\u0017\r\u001a)be\u0006lW\r^3sgR1\u0011qGA\u001f\u0003\u007f\u0001B\u0001FA\u001d\u0005&\u0019\u00111H\u000b\u0003\r=\u0003H/[8o\u0011\u001d\tY\"!\rA\u0002\u001dC\u0001\"a\b\u00022\u0001\u0007\u0011q\u0001\u0005\b\u0003\u0007\u0002A\u0011IA#\u0003-\u0019'/Z1uKZ\u000bG.^3\u0015\u000fq\t9%!\u0014\u0002R!A\u00111DA!\u0001\u0004\tI\u0005E\u0002\u0002L\u0015k\u0011\u0001\u0001\u0005\b\u0003\u001f\n\t\u00051\u0001C\u0003\u0005\u0001\b\u0002CA*\u0003\u0003\u0002\r!!\u0016\u0002\u00179,\u0007\u0010\u001e,feNLwN\u001c\t\u0004)\u0005]\u0013bAA-+\t!Aj\u001c8h\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\n\u0001bZ3u\r2\fwm\u001d\u000b\u0005\u0003C\n9\u0007E\u0002\u0015\u0003GJ1!!\u001a\u0016\u0005\rIe\u000e\u001e\u0005\b\u0003S\nY\u00061\u0001\u0013\u0003\u00151G.Y4t\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\n1bZ3u\u0019&4Wm\u001d9b]R!\u0011\u0011MA9\u0011\u001d\t\u0019(a\u001bA\u0002I\t\u0001\u0002\\5gKN\u0004\u0018M\u001c\u0005\b\u0003o\u0002A\u0011BA=\u0003%9W\r\u001e'f]\u001e$\b\u000e\u0006\u0003\u0002b\u0005m\u0004bBA?\u0003k\u0002\rAE\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\u0006Qq-\u001a;WKJ\u001c\u0018n\u001c8\u0015\t\u0005U\u0013Q\u0011\u0005\b\u0003\u000f\u000by\b1\u0001\u0013\u0003\u001d1XM]:j_:Dq!a#\u0001\t\u0013\ti)\u0001\u0007qCJ\u001cXMT8SKBd\u0017\u0010F\u0003W\u0003\u001f\u000b\u0019\n\u0003\u0005\u0002\u0012\u0006%\u0005\u0019AA1\u00035)\u0007\u0010]3di\u0016$\u0017J\u001c3fq\"A\u0011QSAE\u0001\u0004\t9#\u0001\u0003be\u001e\u001c\bbBAM\u0001\u0011%\u00111T\u0001\u0017a\u0006\u00148/\u001a#fY\u0006LX\r\u001a#fY\u0016$X\rV5nKR1\u0011\u0011MAO\u0003?C\u0001\"!%\u0002\u0018\u0002\u0007\u0011\u0011\r\u0005\t\u0003+\u000b9\n1\u0001\u0002(!9\u00111\u0015\u0001\u0005B\u0005\u0015\u0016\u0001C4fi\u000e\u000b7\r[3\u0015\u00075\u000b9\u000bC\u0004\u0002\u001c\u0005\u0005\u0006\u0019A$\t\r\u0005-\u0006\u0001\"\u0005M\u0003-\u0019'/Z1uK\u000e\u000b7\r[3\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\u0006\u0019\u0002.\u00198eY\u0016\u001cUo\u001d;p[J+\u0017/^3tiRA\u00111WA]\u0003w\u000bi\fE\u0002\u0015\u0003kK1!a.\u0016\u0005\u0019\te.\u001f*fM\"9\u00111DAW\u0001\u00049\u0005\u0002CA\u0010\u0003[\u0003\r!a\u0002\t\r-\u000bi\u000b1\u0001N\u0011\u001d\t\t\r\u0001C!\u0003\u0007\fQc\u0019:fCR,7+^2dKN\u001c(+Z:q_:\u001cX\r\u0006\u0005\u00024\u0006\u0015\u0017qYAf\u0011\u001d\tY\"a0A\u0002\u001dC\u0001\"!3\u0002@\u0002\u0007\u0011qG\u0001\u0007a\u0006\u0014\u0018-\\:\t\u000f\u00055\u0017q\u0018a\u00019\u0005!\u0001O]3w\u0011\u001d\t\t\u000e\u0001C!\u0003'\f\u0011d\u0019:fCR,gj\u001c;Fq\u0016\u001cW\u000f^3e%\u0016\u001c\bo\u001c8tKRA\u00111WAk\u0003/\fI\u000eC\u0004\u0002\u001c\u0005=\u0007\u0019A$\t\u0011\u0005%\u0017q\u001aa\u0001\u0003oAq!!4\u0002P\u0002\u0007A\u0004C\u0004\u0002^\u0002!\t%a8\u0002-\r\u0014X-\u0019;f\u001d>$X\t_5tiJ+7\u000f]8og\u0016$b!a-\u0002b\u0006\r\b\u0002CA\u000e\u00037\u0004\r!!\u0013\t\u0011\u0005%\u00171\u001ca\u0001\u0003oAq!a:\u0001\t\u0003\nI/A\tde\u0016\fG/Z$fiJ+7\u000f]8og\u0016$\u0002\"a-\u0002l\u00065\u0018\u0011\u001f\u0005\b\u00037\t)\u000f1\u0001H\u0011\u001d\ty/!:A\u0002I\t\u0011a\u001b\u0005\b\u0003g\f)\u000f1\u0001\u001d\u0003\u00051\bbBA|\u0001\u0011\u0005\u0013\u0011`\u0001\u0017GJ,\u0017\r^3Nk2$\u0018nR3u%\u0016\u001c\bo\u001c8tKR1\u00111WA~\u0003{Dq!a\u0007\u0002v\u0002\u0007q\t\u0003\u0005\u0002\u0000\u0006U\b\u0019\u0001B\u0001\u0003\u0015\u0001\u0018-\u001b:t!\u0015\u0019\"1\u0001\n\u001d\u0013\r\u0011)a\u0007\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u0005\u0001\u0011\u0005#1B\u0001\u0014GJ,\u0017\r^3FeJ|'OU3ta>t7/\u001a\u000b\u0005\u0003g\u0013i\u0001\u0003\u0005\u0003\u0010\t\u001d\u0001\u0019\u0001B\t\u0003\u0005!\b\u0003\u0002B\n\u0005GqAA!\u0006\u0003 9!!q\u0003B\u000f\u001b\t\u0011IBC\u0002\u0003\u001c)\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0007\t\u0005R#A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015\"q\u0005\u0002\n)\"\u0014xn^1cY\u0016T1A!\t\u0016\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005[\t1c\u0019:fCR,7\u000b^1ugJ+7\u000f]8og\u0016$b!a-\u00030\tM\u0002b\u0002B\u0019\u0005S\u0001\raR\u0001\u0007Q\u0016\fG-\u001a:\t\u0011\tU\"\u0011\u0006a\u0001\u0005o\tQa\u001d;biN\u0004BA!\u000f\u0003>5\u0011!1\b\u0006\u0004\u0005k1\u0011\u0002\u0002B \u0005w\u0011Qa\u0015;biNDqAa\u0011\u0001\t\u0013\u0011)%A\u0005ck&dGm\u0015;biRA\u0011q\u0001B$\u0005\u0017\u0012)\u0006C\u0004\u0003J\t\u0005\u0003\u0019\u0001\n\u0002\tM$\u0018\r\u001e\u0005\t\u0005\u001b\u0012\t\u00051\u0001\u0003P\u0005)a/\u00197vKB\u0019AC!\u0015\n\u0007\tMSCA\u0002B]fD\u0001Ba\u0016\u0003B\u0001\u0007!\u0011L\u0001\u0003g\n\u0004BAa\u0005\u0003\\%!!Q\fB\u0014\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\"9\u00111\t\u0001\u0005\n\t\u0005Dc\u0002\u000f\u0003d\t=$\u0011\u000f\u0005\t\u0005K\u0012y\u00061\u0001\u0003h\u0005!A-\u0019;b!\u0015!\u0012\u0011\u0006B5!\r!\"1N\u0005\u0004\u0005[*\"\u0001\u0002\"zi\u0016D\u0001\"a\u0015\u0003`\u0001\u0007\u0011Q\u000b\u0005\t\u0003S\u0012y\u00061\u0001\u0002b!9!Q\u000f\u0001\u0005\n\t]\u0014\u0001\u00052vS2$w)\u001a;SKN\u0004xN\\:f)!\t9A!\u001f\u0003\n\n-\u0005\u0002\u0003B>\u0005g\u0002\rA! \u0002\u0005=\u0004\b\u0003\u0002B@\u0005\u000b\u00032\u0001\u0006BA\u0013\r\u0011\u0019)\u0006\u0002\f\u000b:,X.\u001a:bi&|g.\u0003\u0003\u0003\b\n\u0005%!\u0002,bYV,\u0007bBAx\u0005g\u0002\rA\u0005\u0005\b\u0003g\u0014\u0019\b1\u0001\u001d\u0011\u001d\u0011y\t\u0001C\u0005\u0005#\u000baCY;jY\u0012<U\r\u001e*fgB|gn]3IK\u0006$WM\u001d\u000b\b%\tM%Q\u0013BL\u0011\u001d\tyO!$A\u0002IAq!a=\u0003\u000e\u0002\u0007A\u0004\u0003\u0005\u0003|\t5\u0005\u0019\u0001B?\u0001")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements TextProtocolUtil,
ScalaObject {
    private final CacheManager cacheManager;
    private final ScheduledExecutorService scheduler;
    private Cache<String, MemcachedValue> cache;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final String CRLF;
    private final byte[] CRLFBytes;
    private final byte[] END;
    private final byte[] DELETED;
    private final byte[] NOT_FOUND;
    private final byte[] EXISTS;
    private final byte[] STORED;
    private final byte[] NOT_STORED;
    private final byte[] OK;
    private final byte[] ERROR;
    private final int CR;
    private final int LF;
    public volatile int bitmap$0;

    @Override
    public String CRLF() {
        return this.CRLF;
    }

    @Override
    public byte[] CRLFBytes() {
        return this.CRLFBytes;
    }

    @Override
    public byte[] END() {
        return this.END;
    }

    @Override
    public byte[] DELETED() {
        return this.DELETED;
    }

    @Override
    public byte[] NOT_FOUND() {
        return this.NOT_FOUND;
    }

    @Override
    public byte[] EXISTS() {
        return this.EXISTS;
    }

    @Override
    public byte[] STORED() {
        return this.STORED;
    }

    @Override
    public byte[] NOT_STORED() {
        return this.NOT_STORED;
    }

    @Override
    public byte[] OK() {
        return this.OK;
    }

    @Override
    public byte[] ERROR() {
        return this.ERROR;
    }

    @Override
    public int CR() {
        return this.CR;
    }

    @Override
    public int LF() {
        return this.LF;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLF_$eq(String string) {
        this.CRLF = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLFBytes_$eq(byte[] byArray) {
        this.CRLFBytes = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$END_$eq(byte[] byArray) {
        this.END = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$DELETED_$eq(byte[] byArray) {
        this.DELETED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_FOUND_$eq(byte[] byArray) {
        this.NOT_FOUND = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$EXISTS_$eq(byte[] byArray) {
        this.EXISTS = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$STORED_$eq(byte[] byArray) {
        this.STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_STORED_$eq(byte[] byArray) {
        this.NOT_STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$OK_$eq(byte[] byArray) {
        this.OK = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$ERROR_$eq(byte[] byArray) {
        this.ERROR = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CR_$eq(int n) {
        this.CR = n;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$LF_$eq(int n) {
        this.LF = n;
    }

    @Override
    public String readElement(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readElement(this, buffer);
    }

    @Override
    public String readLine(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readLine(this, buffer);
    }

    @Override
    public byte[] concat(byte[] a, byte[] b) {
        return TextProtocolUtil$class.concat(this, a, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Cache<String, MemcachedValue> cache() {
        if ((this.bitmap$0 & 1) != 0) return this.cache;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$0 & 1) == 0) {
                this.cache = this.createCache();
                this.bitmap$0 |= 1;
            }
            return this.cache;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$0 & 4) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$0 & 4) == 0) {
                this.isStatsEnabled = this.cache().getConfiguration().isExposeJmxStatistics();
                this.bitmap$0 |= 4;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    public RequestHeader readHeader(ChannelBuffer buffer) {
        Option<Enumeration.Value> op;
        String streamOp = this.readElement(buffer);
        Option<Enumeration.Value> option = op = RequestResolver$.MODULE$.toRequest(streamOp);
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            String line = this.readLine(buffer);
            throw new UnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)streamOp).toString());
        }
        return new RequestHeader((Enumeration.Value)op.get());
    }

    public String readKey(RequestHeader h, ChannelBuffer b) {
        return this.readElement(b);
    }

    public String[] readKeys(RequestHeader h, ChannelBuffer b) {
        String line = this.readLine(b);
        return line.trim().split(" +");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<MemcachedParameters> readParameters(RequestHeader h, ChannelBuffer b) {
        Enumeration.Value temp1;
        Enumeration.Value temp2;
        int index;
        String[] args;
        None$ none$;
        block7: {
            block6: {
                String line = this.readLine(b);
                if (line.isEmpty()) {
                    none$ = None$.MODULE$;
                    return none$;
                }
                RequestResolver$.MODULE$.trace((Function0)new $anonfun$readParameters$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line}));
                args = line.trim().split(" +");
                index = 0;
                Enumeration.Value value = temp2 = h.op();
                Enumeration.Value value2 = Operation$.MODULE$.RemoveRequest();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    int delayedDeleteTime = this.parseDelayedDeleteTime(index, args);
                    boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(index, args) : false;
                    none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, noReply, 0, "", 0));
                    return none$;
                }
                Enumeration.Value value3 = temp2;
                Enumeration.Value value4 = MemcachedOperation$.MODULE$.IncrementRequest();
                if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block6;
                Enumeration.Value value5 = temp2;
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.DecrementRequest();
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block7;
            }
            String delta = args[index];
            none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, this.parseNoReply(++index, args), 0, delta, 0));
            return none$;
        }
        Enumeration.Value value = temp2;
        Enumeration.Value value7 = MemcachedOperation$.MODULE$.FlushAllRequest();
        if (!(value != null ? !value.equals(value7) : value7 != null)) {
            int flushDelay = Predef$.MODULE$.augmentString(args[index]).toInt();
            none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, this.parseNoReply(++index, args), 0, "", flushDelay));
            return none$;
        }
        int flags = this.getFlags(args[index]);
        int streamLifespan = this.getLifespan(args[++index]);
        int lifespan = streamLifespan <= 0 ? -1 : streamLifespan;
        int length = this.getLength(args[++index]);
        Enumeration.Value value8 = temp1 = h.op();
        Enumeration.Value value9 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        long streamVersion = !(value8 != null ? !value8.equals(value9) : value9 != null) ? this.getVersion(args[++index]) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        byte[] data = new byte[length];
        b.readBytes(data, 0, data.length);
        this.readLine(b);
        none$ = new Some((Object)new MemcachedParameters(data, lifespan, -1, streamVersion, noReply, flags, "", 0));
        return none$;
    }

    public MemcachedValue createValue(RequestHeader h, MemcachedParameters p, long nextVersion) {
        return new MemcachedValue(p.data(), nextVersion, p.flags());
    }

    private int getFlags(String flags) {
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        return Predef$.MODULE$.augmentString(flags).toInt();
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return Predef$.MODULE$.augmentString(lifespan).toInt();
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return Predef$.MODULE$.augmentString(length).toInt();
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, String[] args) {
        if (args.length <= expectedIndex) return false;
        String string = args[expectedIndex];
        if ("noreply" != null) {
            if (!"noreply".equals(string)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (string == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(int expectedIndex, String[] args) {
        int n;
        if (args.length <= expectedIndex) return 0;
        int exceptionResult1 = 0;
        try {
            n = exceptionResult1 = Predef$.MODULE$.augmentString(args[expectedIndex]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache(RequestHeader h) {
        return this.cache();
    }

    public Cache<String, MemcachedValue> createCache() {
        return this.cacheManager.getCache();
    }

    public Object handleCustomRequest(RequestHeader h, ChannelBuffer b, Cache<String, MemcachedValue> cache) {
        Enumeration.Value temp5;
        block22: {
            Object object;
            block10: {
                block21: {
                    block15: {
                        Enumeration.Value temp4;
                        block19: {
                            String prevCounter;
                            block20: {
                                Object object2;
                                long l;
                                MemcachedValue prev;
                                Option<MemcachedParameters> params;
                                String k;
                                block18: {
                                    block17: {
                                        block16: {
                                            Object object3;
                                            block14: {
                                                block8: {
                                                    Enumeration.Value temp3;
                                                    block13: {
                                                        byte[] byArray;
                                                        MemcachedValue prev2;
                                                        Option<MemcachedParameters> params2;
                                                        String k2;
                                                        block12: {
                                                            block11: {
                                                                block9: {
                                                                    block7: {
                                                                        Enumeration.Value value = temp5 = h.op();
                                                                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                        if (!(value == null ? value2 != null : !value.equals(value2))) break block7;
                                                                        Enumeration.Value value3 = temp5;
                                                                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                                                                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block8;
                                                                    }
                                                                    k2 = this.readKey(h, b);
                                                                    params2 = this.readParameters(h, b);
                                                                    prev2 = (MemcachedValue)((Object)cache.get(k2));
                                                                    if (prev2 != null) break block9;
                                                                    object = ((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED();
                                                                    break block10;
                                                                }
                                                                Enumeration.Value value = temp3 = h.op();
                                                                Enumeration.Value value5 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                if (value != null ? !value.equals(value5) : value5 != null) break block11;
                                                                byArray = this.concat(prev2.data(), ((MemcachedParameters)((Object)params2.get())).data());
                                                                break block12;
                                                            }
                                                            Enumeration.Value value = temp3;
                                                            Enumeration.Value value6 = MemcachedOperation$.MODULE$.PrependRequest();
                                                            if (value != null ? !value.equals(value6) : value6 != null) break block13;
                                                            byArray = this.concat(((MemcachedParameters)((Object)params2.get())).data(), prev2.data());
                                                        }
                                                        byte[] concatenated = byArray;
                                                        MemcachedValue next = this.createValue(concatenated, this.generateVersion(cache), ((MemcachedParameters)((Object)params2.get())).flags());
                                                        boolean replaced = cache.replace(k2, prev2, next);
                                                        object = replaced ? (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.STORED()) : (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED());
                                                        break block10;
                                                    }
                                                    throw new MatchError((Object)temp3);
                                                }
                                                Enumeration.Value value = temp5;
                                                Enumeration.Value value7 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                if (!(value == null ? value7 != null : !value.equals(value7))) break block14;
                                                Enumeration.Value value8 = temp5;
                                                Enumeration.Value value9 = MemcachedOperation$.MODULE$.DecrementRequest();
                                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block15;
                                            }
                                            k = this.readKey(h, b);
                                            params = this.readParameters(h, b);
                                            prev = (MemcachedValue)((Object)cache.get(k));
                                            if (prev != null) break block16;
                                            if (this.isStatsEnabled()) {
                                                Enumeration.Value value = h.op();
                                                Enumeration.Value value10 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                object3 = BoxesRunTime.boxToLong((long)(!(value != null ? !value.equals(value10) : value10 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                            } else {
                                                object3 = BoxedUnit.UNIT;
                                            }
                                            object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND();
                                            break block10;
                                        }
                                        prevCounter = new String(prev.data());
                                        Enumeration.Value value = temp4 = h.op();
                                        Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
                                        if (value != null ? !value.equals(value11) : value11 != null) break block17;
                                        l = Predef$.MODULE$.augmentString(prevCounter).toLong() + Predef$.MODULE$.augmentString(((MemcachedParameters)((Object)params.get())).delta()).toLong();
                                        break block18;
                                    }
                                    Enumeration.Value value = temp4;
                                    Enumeration.Value value12 = MemcachedOperation$.MODULE$.DecrementRequest();
                                    if (value != null ? !value.equals(value12) : value12 != null) break block19;
                                    long candidateCounter = Predef$.MODULE$.augmentString(prevCounter).toLong() - Predef$.MODULE$.augmentString(((MemcachedParameters)((Object)params.get())).delta()).toLong();
                                    l = candidateCounter < 0L ? 0L : candidateCounter;
                                }
                                long newCounter = l;
                                MemcachedValue next = this.createValue(((Object)BoxesRunTime.boxToLong((long)newCounter)).toString().getBytes(), this.generateVersion(cache), ((MemcachedParameters)((Object)params.get())).flags());
                                boolean replaced = cache.replace(k, prev, next);
                                if (!replaced) break block20;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value = h.op();
                                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object2 = BoxesRunTime.boxToLong((long)(!(value != null ? !value.equals(value13) : value13 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                                } else {
                                    object2 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next.data())).append((Object)this.CRLF()).toString();
                                break block10;
                            }
                            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
                        }
                        throw new MatchError((Object)temp4);
                    }
                    Enumeration.Value value = temp5;
                    Enumeration.Value value14 = MemcachedOperation$.MODULE$.FlushAllRequest();
                    if (value != null ? !value.equals(value14) : value14 != null) break block21;
                    Option<MemcachedParameters> params = this.readParameters(h, b);
                    $anonfun$1 flushFunction = new $anonfun$1(this);
                    Option<MemcachedParameters> option = params;
                    None$ none$ = None$.MODULE$;
                    int flushDelay = !(option != null ? !option.equals((Object)none$) : none$ != null) ? 0 : ((MemcachedParameters)((Object)params.get())).flushDelay();
                    ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply(cache.getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll(cache, (Function1<AdvancedCache<String, MemcachedValue>, Object>)flushFunction), (long)flushDelay, TimeUnit.SECONDS);
                    Option<MemcachedParameters> option2 = params;
                    None$ none$2 = None$.MODULE$;
                    object = (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.OK();
                    break block10;
                }
                Enumeration.Value value = temp5;
                Enumeration.Value value15 = MemcachedOperation$.MODULE$.VersionRequest();
                if (value != null ? !value.equals(value15) : value15 != null) break block22;
                object = new StringBuilder().append("VERSION ").append("4.1.0.ALPHA3").append(this.CRLF());
            }
            return object;
        }
        throw new MatchError((Object)temp5);
    }

    public Object createSuccessResponse(RequestHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value temp6;
            Enumeration.Value value = temp6 = h.op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value temp7;
            Enumeration.Value value = temp7 = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.RemoveRequest();
            byArray = !(value != null ? !value.equals(value3) : value3 != null) ? this.DELETED() : this.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(RequestHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value temp8;
            Enumeration.Value value = temp8 = h.op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value temp9;
            Enumeration.Value value = temp9 = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            byArray = !(value != null ? !value.equals(value3) : value3 != null) ? this.EXISTS() : this.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse(RequestHeader h, Option<MemcachedParameters> params) {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value temp10;
            Enumeration.Value value = temp10 = h.op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        return (byte[])((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND());
    }

    public Object createGetResponse(RequestHeader h, String k, MemcachedValue v) {
        return v == null ? this.END() : (byte[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(h.op(), k, v), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    public Object createMultiGetResponse(RequestHeader h$1, Map<String, MemcachedValue> pairs) {
        Enumeration.Value temp14;
        block3: {
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                Enumeration.Value value = temp14 = h$1.op();
                Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                if (!(value == null ? value2 != null : !value.equals(value2))) break block2;
                Enumeration.Value value3 = temp14;
                Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                if (value3 != null ? !value3.equals(value4) : value4 != null) break block3;
            }
            pairs.foreach((Function1)new $anonfun$createMultiGetResponse$1(this, h$1, elements$1));
            elements$1.$plus$eq((Object)ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{"END\r\n".getBytes()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)temp14);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        StringBuilder sb = new StringBuilder();
        Throwable temp20 = t;
        if (temp20 instanceof ServerException) {
            ServerException temp21 = (ServerException)temp20;
            ServerException se = temp21;
            Throwable temp17 = se.getCause();
            if (temp17 instanceof UnknownOperationException) {
                object = this.ERROR();
            } else if (temp17 instanceof ClosedChannelException) {
                object = null;
            } else {
                Throwable temp15 = t;
                StringBuilder stringBuilder = temp15 instanceof IOException ? sb.append("CLIENT_ERROR ") : sb.append("SERVER_ERROR ");
                object = sb.append((Object)t).append(this.CRLF());
            }
        } else {
            object = temp20 instanceof ClosedChannelException ? null : sb.append("SERVER_ERROR ").append((Object)t).append(this.CRLF());
        }
        return object;
    }

    public Object createStatsResponse(RequestHeader header, Stats stats) {
        StringBuilder sb = new StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("bytes_written", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(this.CRLF());
        ChannelBuffer buffer = ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, int flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        String header = this.buildGetResponseHeader(k, v, op);
        return ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{header.getBytes(), v.data(), this.CRLFBytes()}));
    }

    private String buildGetResponseHeader(String k, MemcachedValue v, Enumeration.Value op) {
        StringBuilder sb = new StringBuilder();
        sb.append("VALUE ").append(k).append(" ").append(v.flags()).append(" ").append(v.data().length).append(" ");
        Enumeration.Value value = op;
        Enumeration.Value value2 = Operation$.MODULE$.GetWithVersionRequest();
        Object object = !(value != null ? !value.equals(value2) : value2 != null) ? sb.append(v.version()).append(" ") : BoxedUnit.UNIT;
        sb.append(this.CRLF());
        return sb.toString();
    }

    public MemcachedDecoder(CacheManager cacheManager, ScheduledExecutorService scheduler) {
        this.cacheManager = cacheManager;
        this.scheduler = scheduler;
        TextProtocolUtil$class.$init$(this);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
    }
}

