/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.transport;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.Cache;
import org.infinispan.server.core.UnknownCommandException;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.core.transport.Decoder;
import org.infinispan.server.core.transport.ExceptionEvent;
import org.infinispan.server.memcached.Command;
import org.infinispan.server.memcached.InterceptorChain;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandFactory;
import org.infinispan.server.memcached.commands.StorageCommand;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TextDecoder
implements Decoder<State> {
    private static final Log log = LogFactory.getLog(TextDecoder.class);
    private final CommandFactory factory;
    private volatile TextCommand command;
    private Decoder.Checkpointer checkpointer;

    public TextDecoder(Cache<String, Value> cache, InterceptorChain chain, ScheduledExecutorService scheduler) {
        this.factory = new CommandFactory(cache, chain, scheduler);
    }

    public void setCheckpointer(Decoder.Checkpointer checkpointer) {
        this.checkpointer = checkpointer;
    }

    public Object decode(ChannelHandlerContext ctx, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case READ_COMMAND: {
                this.command = this.factory.createCommand(this.readLine(buffer));
                if (this.command.getType().isStorage()) {
                    this.checkpointer.checkpoint((Object)State.READ_UNSTRUCTURED_DATA);
                    break;
                }
                return this.command;
            }
            case READ_UNSTRUCTURED_DATA: {
                StorageCommand storageCmd = (StorageCommand)this.command;
                byte[] data = new byte[storageCmd.getParams().getBytes()];
                buffer.readBytes(data, 0, data.length);
                byte next = buffer.readByte();
                if (next == 13) {
                    next = buffer.readByte();
                    if (next == 10) {
                        try {
                            return this.reset(storageCmd.setData(data));
                        }
                        catch (IOException ioe) {
                            this.checkpointer.checkpoint((Object)State.READ_COMMAND);
                            throw ioe;
                        }
                    }
                    throw new StreamCorruptedException("Expecting \r\n after data block");
                }
                throw new StreamCorruptedException("Expecting \r\n after data block");
            }
        }
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable t = e.getCause();
        log.error((Object)"Unexpected exception", t);
        Channel ch = ctx.getChannel();
        ChannelBuffers buffers = ctx.getChannelBuffers();
        if (t instanceof UnknownCommandException) {
            ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(Reply.ERROR.bytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        } else if (t instanceof IOException) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)Reply.CLIENT_ERROR).append(' ').append(t);
            ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(sb.toString().getBytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)Reply.SERVER_ERROR).append(' ').append(t);
            ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(sb.toString().getBytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        }
    }

    private Object reset(Command c) {
        this.command = null;
        this.checkpointer.checkpoint((Object)State.READ_COMMAND);
        return c;
    }

    private String readLine(ChannelBuffer buffer) {
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        while (true) {
            byte next;
            if ((next = buffer.readByte()) == 13) {
                next = buffer.readByte();
                if (next != 10) continue;
                return sb.toString();
            }
            if (next == 10) {
                return sb.toString();
            }
            ++lineLength;
            sb.append((char)next);
        }
    }

    public static enum State {
        READ_COMMAND,
        READ_UNSTRUCTURED_DATA;

    }
}

