/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.interceptors;

import org.infinispan.Cache;
import org.infinispan.server.memcached.InterceptorChain;
import org.infinispan.server.memcached.InterceptorChainFactory;
import org.infinispan.server.memcached.interceptors.CallInterceptor;
import org.infinispan.server.memcached.interceptors.StatsInterceptor;
import org.infinispan.server.memcached.interceptors.TextCommandInterceptorImpl;
import org.infinispan.server.memcached.interceptors.TextProtocolInterceptorChain;

public enum TextProtocolInterceptorChainFactory implements InterceptorChainFactory
{
    STATS_ENABLED(true),
    NOT_STATS_ENABLED(false);

    private final boolean statsEnabled;

    private TextProtocolInterceptorChainFactory(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    @Override
    public InterceptorChain buildInterceptorChain() {
        TextCommandInterceptorImpl first = this.statsEnabled ? new StatsInterceptor(new CallInterceptor(null)) : new CallInterceptor(null);
        return new TextProtocolInterceptorChain(first);
    }

    public static TextProtocolInterceptorChainFactory getInstance(Cache cache) {
        if (cache.getConfiguration().isExposeJmxStatistics()) {
            return STATS_ENABLED;
        }
        return NOT_STATS_ENABLED;
    }
}

