/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Command;
import org.infinispan.server.memcached.CommandInterceptor;
import org.infinispan.server.memcached.InterceptorChain;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.interceptors.TextCommandInterceptor;

public class TextProtocolInterceptorChain
implements InterceptorChain {
    private final TextCommandInterceptor firstInChain;

    public TextProtocolInterceptorChain(TextCommandInterceptor firstInChain) {
        this.firstInChain = firstInChain;
    }

    @Override
    public Object invoke(ChannelHandlerContext ctx, Command command) throws Throwable {
        return ((TextCommand)command).acceptVisitor(ctx, this.firstInChain);
    }

    @Override
    public List<CommandInterceptor> getInterceptorsWhichExtend(Class<? extends CommandInterceptor> interceptorClass) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>();
        for (CommandInterceptor interceptor : this.asList()) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            result.add(interceptor);
        }
        return result;
    }

    private List<CommandInterceptor> asList() {
        if (this.firstInChain == null) {
            return Collections.emptyList();
        }
        LinkedList<TextCommandInterceptor> retval = new LinkedList<TextCommandInterceptor>();
        CommandInterceptor tmp = this.firstInChain;
        do {
            retval.add((TextCommandInterceptor)tmp);
        } while ((tmp = tmp.getNext()) != null);
        return Collections.unmodifiableList(retval);
    }
}

