/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.commands.CasCommand;
import org.infinispan.server.memcached.commands.DecrementCommand;
import org.infinispan.server.memcached.commands.IncrementCommand;
import org.infinispan.server.memcached.commands.MemcachedStats;
import org.infinispan.server.memcached.interceptors.TextCommandInterceptor;
import org.infinispan.server.memcached.interceptors.TextCommandInterceptorImpl;

public class StatsInterceptor
extends TextCommandInterceptorImpl
implements MemcachedStats {
    private final AtomicLong incrMisses = new AtomicLong(0L);
    private final AtomicLong incrHits = new AtomicLong(0L);
    private final AtomicLong decrMisses = new AtomicLong(0L);
    private final AtomicLong decrHits = new AtomicLong(0L);
    private final AtomicLong casMisses = new AtomicLong(0L);
    private final AtomicLong casHits = new AtomicLong(0L);
    private final AtomicLong casBadval = new AtomicLong(0L);

    public StatsInterceptor(TextCommandInterceptor next) {
        super(next);
    }

    @Override
    public Object visitIncrement(ChannelHandlerContext ctx, IncrementCommand command) throws Throwable {
        Object ret = this.invokeNextInterceptor(ctx, command);
        if (ret != Reply.NOT_FOUND) {
            this.incrHits.incrementAndGet();
        } else {
            this.incrMisses.incrementAndGet();
        }
        return ret;
    }

    @Override
    public Object visitDecrement(ChannelHandlerContext ctx, DecrementCommand command) throws Throwable {
        Object ret = this.invokeNextInterceptor(ctx, command);
        if (ret != Reply.NOT_FOUND) {
            this.decrHits.incrementAndGet();
        } else {
            this.decrMisses.incrementAndGet();
        }
        return ret;
    }

    @Override
    public Object visitCas(ChannelHandlerContext ctx, CasCommand command) throws Throwable {
        Reply ret = (Reply)((Object)this.invokeNextInterceptor(ctx, command));
        switch (ret) {
            case STORED: {
                this.casHits.incrementAndGet();
                break;
            }
            case NOT_FOUND: {
                this.casMisses.incrementAndGet();
                break;
            }
            case EXISTS: {
                this.casBadval.incrementAndGet();
            }
        }
        return ret;
    }

    @Override
    public long getIncrHits() {
        return this.incrHits.get();
    }

    @Override
    public long getIncrMisses() {
        return this.incrMisses.get();
    }

    @Override
    public long getDecrHits() {
        return this.decrHits.get();
    }

    @Override
    public long getDecrMisses() {
        return this.decrMisses.get();
    }

    @Override
    public long getCasBadval() {
        return this.casBadval.get();
    }

    @Override
    public long getCasHits() {
        return this.casHits.get();
    }

    @Override
    public long getCasMisses() {
        return this.casMisses.get();
    }
}

