/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class Value
implements Externalizable {
    private int flags;
    private byte[] data;
    private long cas;
    private static final long serialVersionUID = -8421160896234703067L;

    Value(int flags, byte[] data, long cas) {
        this.flags = flags;
        this.data = data;
        this.cas = cas;
    }

    public int getFlags() {
        return this.flags;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getCas() {
        return this.cas;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value)obj;
        return Arrays.equals(this.data, other.data) && this.flags == other.flags && this.cas == other.cas;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.flags;
        result = 31 * result + this.data.hashCode();
        result = 31 * result + (int)(this.cas ^ this.cas >>> 32);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "data=" + this.data + ", flags=" + this.flags + ", cas=" + this.cas + "}";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.flags = in.read();
        this.data = new byte[in.read()];
        in.read(this.data);
        this.cas = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(this.flags);
        out.write(this.data.length);
        out.write(this.data);
        out.writeLong(this.cas);
    }
}

