/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.io.IOException;
import java.io.StreamCorruptedException;
import org.infinispan.Cache;
import org.infinispan.server.memcached.Command;
import org.infinispan.server.memcached.commands.AddCommand;
import org.infinispan.server.memcached.commands.AppendCommand;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.PrependCommand;
import org.infinispan.server.memcached.commands.ReplaceCommand;
import org.infinispan.server.memcached.commands.SetCommand;
import org.infinispan.server.memcached.commands.StorageParameters;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.commands.Value;

public abstract class StorageCommand
implements TextCommand {
    private final CommandType type;
    final Cache<String, Value> cache;
    final StorageParameters params;
    final byte[] data;
    final boolean noReply;

    StorageCommand(Cache<String, Value> cache, CommandType type, StorageParameters params, byte[] data, boolean noReply) {
        this.type = type;
        this.params = params;
        this.cache = cache;
        this.data = data;
        this.noReply = noReply;
    }

    @Override
    public CommandType getType() {
        return this.type;
    }

    public Command setData(byte[] data) throws IOException {
        return StorageCommand.newStorageCommand(this.cache, this.type, this.params, data, this.noReply);
    }

    public StorageParameters getParams() {
        return this.params;
    }

    public static TextCommand newStorageCommand(Cache<String, Value> cache, CommandType type, StorageParameters params, byte[] data, boolean noReply) throws IOException {
        switch (type) {
            case SET: {
                return new SetCommand(cache, type, params, data, noReply);
            }
            case ADD: {
                return new AddCommand(cache, type, params, data, noReply);
            }
            case REPLACE: {
                return new ReplaceCommand(cache, type, params, data, noReply);
            }
            case APPEND: {
                return new AppendCommand(cache, type, params, data, noReply);
            }
            case PREPEND: {
                return new PrependCommand((Cache)cache, type, params, data, noReply);
            }
        }
        throw new StreamCorruptedException("Unable to build storage command for type: " + (Object)((Object)type));
    }
}

