/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.InterceptorChain;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.MemcachedStatsImpl;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class StatsCommand
implements TextCommand {
    final Cache cache;
    private final CommandType type;
    final InterceptorChain chain;

    StatsCommand(Cache cache, CommandType type, InterceptorChain chain) {
        this.cache = cache;
        this.type = type;
        this.chain = chain;
    }

    @Override
    public CommandType getType() {
        return CommandType.STATS;
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitStats(ctx, this);
    }

    @Override
    public Object perform(ChannelHandlerContext ctx) throws Throwable {
        MemcachedStatsImpl stats = new MemcachedStatsImpl(this.cache.getAdvancedCache().getStats(), this.chain);
        StringBuilder sb = new StringBuilder();
        this.writeStat("pid", 0, sb, ctx);
        this.writeStat("uptime", stats.getTimeSinceStart(), sb, ctx);
        this.writeStat("time", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()), sb, ctx);
        this.writeStat("version", this.cache.getVersion(), sb, ctx);
        this.writeStat("pointer_size", 0, sb, ctx);
        this.writeStat("rusage_user", 0, sb, ctx);
        this.writeStat("rusage_system", 0, sb, ctx);
        this.writeStat("curr_items", stats.getCurrentNumberOfEntries(), sb, ctx);
        this.writeStat("total_items", stats.getTotalNumberOfEntries(), sb, ctx);
        this.writeStat("bytes", 0, sb, ctx);
        this.writeStat("curr_connections", 0, sb, ctx);
        this.writeStat("total_connections", 0, sb, ctx);
        this.writeStat("connection_structures", 0, sb, ctx);
        this.writeStat("cmd_get", stats.getRetrievals(), sb, ctx);
        this.writeStat("cmd_set", stats.getStores(), sb, ctx);
        this.writeStat("get_hits", stats.getHits(), sb, ctx);
        this.writeStat("get_misses", stats.getMisses(), sb, ctx);
        this.writeStat("delete_misses", stats.getRemoveMisses(), sb, ctx);
        this.writeStat("delete_hits", stats.getRemoveHits(), sb, ctx);
        this.writeStat("incr_misses", stats.getIncrMisses(), sb, ctx);
        this.writeStat("incr_hits", stats.getIncrHits(), sb, ctx);
        this.writeStat("decr_misses", stats.getDecrMisses(), sb, ctx);
        this.writeStat("decr_hits", stats.getDecrHits(), sb, ctx);
        this.writeStat("cas_misses", stats.getCasMisses(), sb, ctx);
        this.writeStat("cas_hits", stats.getCasHits(), sb, ctx);
        this.writeStat("cas_badval", stats.getCasBadval(), sb, ctx);
        this.writeStat("auth_cmds", 0, sb, ctx);
        this.writeStat("auth_errors", 0, sb, ctx);
        this.writeStat("evictions", stats.getEvictions(), sb, ctx);
        this.writeStat("bytes_read", 0, sb, ctx);
        this.writeStat("bytes_written", 0, sb, ctx);
        this.writeStat("limit_maxbytes", 0, sb, ctx);
        this.writeStat("threads", 0, sb, ctx);
        this.writeStat("conn_yields", 0, sb, ctx);
        ChannelBuffers buffers = ctx.getChannelBuffers();
        Channel ch = ctx.getChannel();
        ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(Reply.END.bytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        return Reply.END;
    }

    private void writeStat(String stat, Object value, StringBuilder sb, ChannelHandlerContext ctx) {
        ChannelBuffers buffers = ctx.getChannelBuffers();
        Channel ch = ctx.getChannel();
        sb.append((Object)Reply.STAT).append(' ').append(stat).append(' ').append(value);
        ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(sb.toString().getBytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        sb.setLength(0);
    }

    public static TextCommand newStatsCommand(Cache cache, CommandType type, InterceptorChain chain) {
        return new StatsCommand(cache, type, chain);
    }
}

