/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.StorageCommand;
import org.infinispan.server.memcached.commands.StorageParameters;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SetCommand
extends StorageCommand {
    private static final Log log = LogFactory.getLog(SetCommand.class);

    SetCommand(Cache<String, Value> cache, CommandType type, StorageParameters params, byte[] data, boolean noReply) {
        super(cache, type, params, data, noReply);
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitSet(ctx, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object perform(ChannelHandlerContext ctx) throws Exception {
        Reply reply;
        Channel ch;
        block7: {
            ch = ctx.getChannel();
            try {
                if (this.params.expiry == 0L) {
                    reply = this.put(this.params.key, this.params.flags, this.data);
                    break block7;
                }
                if (this.params.expiry > 2592000L) {
                    long future = TimeUnit.SECONDS.toMillis(this.params.expiry);
                    long expiry = future - System.currentTimeMillis();
                    if (expiry <= 0L) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Given expiry is bigger than 30 days, hence is treated as Unix time, ").append("but this time is in the past: ").append(future).append(", date: ").append(new Date(future));
                        throw new CacheException(sb.toString());
                    }
                    reply = this.put(this.params.key, this.params.flags, this.data, expiry);
                } else {
                    long expiry = TimeUnit.SECONDS.toMillis(this.params.expiry);
                    reply = this.put(this.params.key, this.params.flags, this.data, expiry);
                }
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception performing command", (Throwable)e);
                reply = Reply.NOT_STORED;
            }
        }
        if (!this.noReply) {
            ChannelBuffers buffers = ctx.getChannelBuffers();
            ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(reply.bytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        }
        return reply;
    }

    protected Reply put(String key, int flags, byte[] data) {
        return this.put(key, flags, data, -1L);
    }

    protected Reply put(String key, int flags, byte[] data, long expiry) {
        Value prev = (Value)this.cache.get((Object)key);
        if (prev != null) {
            Value value = new Value(flags, data, prev.getCas() + 1L);
            boolean replaced = this.cache.replace((Object)key, (Object)prev, (Object)value, expiry, TimeUnit.MILLISECONDS);
            return this.reply(replaced);
        }
        Value value = new Value(flags, data, System.currentTimeMillis());
        prev = (Value)this.cache.putIfAbsent((Object)key, (Object)value, expiry, TimeUnit.MILLISECONDS);
        return this.reply(prev);
    }

    private Reply reply(boolean replaced) {
        if (!replaced) {
            return Reply.NOT_STORED;
        }
        return Reply.STORED;
    }

    private Reply reply(Value prev) {
        if (prev == null) {
            return Reply.STORED;
        }
        return Reply.NOT_STORED;
    }
}

