/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import org.infinispan.Cache;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.GetCommand;
import org.infinispan.server.memcached.commands.GetsCommand;
import org.infinispan.server.memcached.commands.RetrievalParameters;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.commands.Value;

public abstract class RetrievalCommand
implements TextCommand {
    final Cache<String, Value> cache;
    private final CommandType type;
    final RetrievalParameters params;

    RetrievalCommand(Cache<String, Value> cache, CommandType type, RetrievalParameters params) {
        this.cache = cache;
        this.type = type;
        this.params = params;
    }

    @Override
    public CommandType getType() {
        return this.type;
    }

    public static TextCommand newRetrievalCommand(Cache<String, Value> cache, CommandType type, RetrievalParameters params) {
        switch (type) {
            case GET: {
                return new GetCommand(cache, type, params);
            }
            case GETS: {
                return new GetsCommand((Cache)cache, type, params);
            }
        }
        throw new IllegalStateException("Unable to build storage command for type: " + (Object)((Object)type));
    }
}

