/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.SetCommand;
import org.infinispan.server.memcached.commands.StorageParameters;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class ReplaceCommand
extends SetCommand {
    ReplaceCommand(Cache<String, Value> cache, CommandType type, StorageParameters params, byte[] data, boolean noReply) {
        super(cache, type, params, data, noReply);
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitReplace(ctx, this);
    }

    @Override
    protected Reply put(String key, int flags, byte[] data, long expiry) {
        Value old = (Value)this.cache.get((Object)key);
        if (old != null) {
            Value value = new Value(flags, data, old.getCas() + 1L);
            boolean replaced = this.cache.replace((Object)this.params.key, (Object)old, (Object)value, expiry, TimeUnit.MILLISECONDS);
            return this.reply(replaced);
        }
        return this.reply(old);
    }

    private Reply reply(Value prev) {
        if (prev == null) {
            return Reply.NOT_STORED;
        }
        return Reply.STORED;
    }

    private Reply reply(boolean replaced) {
        if (!replaced) {
            return Reply.NOT_STORED;
        }
        return Reply.STORED;
    }
}

