/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.DecrementCommand;
import org.infinispan.server.memcached.commands.IncrementCommand;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class NumericCommand
implements TextCommand {
    private static final Log log = LogFactory.getLog(NumericCommand.class);
    final Cache cache;
    private final CommandType type;
    final String key;
    final String delta;
    final boolean noReply;

    public NumericCommand(Cache cache, CommandType type, String key, String delta, boolean noReply) {
        this.cache = cache;
        this.type = type;
        this.key = key;
        this.delta = delta;
        this.noReply = noReply;
    }

    @Override
    public CommandType getType() {
        return this.type;
    }

    @Override
    public Object perform(ChannelHandlerContext ctx) throws Throwable {
        Channel ch = ctx.getChannel();
        ChannelBuffers buffers = ctx.getChannelBuffers();
        Value old = (Value)this.cache.get((Object)this.key);
        if (old != null) {
            String prev = old.getData().length == 0 ? "0" : new String(old.getData());
            BigInteger newBigInt = this.operate(new BigInteger(prev), new BigInteger(this.delta));
            byte[] newData = newBigInt.toString().getBytes();
            Value curr = new Value(old.getFlags(), newData, old.getCas() + 1L);
            boolean replaced = this.cache.replace((Object)this.key, (Object)old, (Object)curr);
            if (replaced && !this.noReply) {
                ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(newData), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
            } else if (!replaced) {
                throw new CacheException("Value modified since we retrieved from the cache, old value was " + prev);
            }
            return curr;
        }
        if (!this.noReply) {
            ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(Reply.NOT_FOUND.bytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        }
        return Reply.NOT_FOUND;
    }

    protected abstract BigInteger operate(BigInteger var1, BigInteger var2);

    public static TextCommand newNumericCommand(Cache cache, CommandType type, String key, String delta, boolean noReply) throws IOException {
        switch (type) {
            case INCR: {
                return new IncrementCommand(cache, type, key, delta, noReply);
            }
            case DECR: {
                return new DecrementCommand(cache, type, key, delta, noReply);
            }
        }
        throw new StreamCorruptedException("Unable to build storage command for type: " + (Object)((Object)type));
    }
}

