/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.util.List;
import org.infinispan.server.memcached.CommandInterceptor;
import org.infinispan.server.memcached.InterceptorChain;
import org.infinispan.server.memcached.commands.MemcachedStats;
import org.infinispan.server.memcached.interceptors.StatsInterceptor;
import org.infinispan.stats.Stats;

public class MemcachedStatsImpl
implements MemcachedStats,
Stats {
    final Stats cacheStats;
    final long incrMisses;
    final long incrHits;
    final long decrMisses;
    final long decrHits;
    final long casMisses;
    final long casHits;
    final long casBadval;

    MemcachedStatsImpl(Stats cacheStats, InterceptorChain chain) {
        this.cacheStats = cacheStats;
        List<CommandInterceptor> interceptors = chain.getInterceptorsWhichExtend(StatsInterceptor.class);
        if (!interceptors.isEmpty()) {
            StatsInterceptor statsInt = (StatsInterceptor)interceptors.get(0);
            this.incrMisses = statsInt.getIncrMisses();
            this.incrHits = statsInt.getIncrHits();
            this.decrMisses = statsInt.getDecrMisses();
            this.decrHits = statsInt.getDecrHits();
            this.casMisses = statsInt.getCasMisses();
            this.casHits = statsInt.getCasHits();
            this.casBadval = statsInt.getCasBadval();
        } else {
            this.incrMisses = -1L;
            this.incrHits = -1L;
            this.decrMisses = -1L;
            this.decrHits = -1L;
            this.casMisses = -1L;
            this.casHits = -1L;
            this.casBadval = -1L;
        }
    }

    @Override
    public long getCasBadval() {
        return this.casBadval;
    }

    @Override
    public long getCasHits() {
        return this.casHits;
    }

    @Override
    public long getCasMisses() {
        return this.casMisses;
    }

    @Override
    public long getDecrHits() {
        return this.decrHits;
    }

    @Override
    public long getDecrMisses() {
        return this.decrMisses;
    }

    @Override
    public long getIncrHits() {
        return this.incrHits;
    }

    @Override
    public long getIncrMisses() {
        return this.incrMisses;
    }

    public int getCurrentNumberOfEntries() {
        return this.cacheStats.getCurrentNumberOfEntries();
    }

    public long getEvictions() {
        return this.cacheStats.getEvictions();
    }

    public long getHits() {
        return this.cacheStats.getHits();
    }

    public long getMisses() {
        return this.cacheStats.getMisses();
    }

    public long getRemoveHits() {
        return this.cacheStats.getRemoveHits();
    }

    public long getRemoveMisses() {
        return this.cacheStats.getRemoveMisses();
    }

    public long getRetrievals() {
        return this.cacheStats.getRetrievals();
    }

    public long getStores() {
        return this.cacheStats.getStores();
    }

    public long getTimeSinceStart() {
        return this.cacheStats.getTimeSinceStart();
    }

    public long getTotalNumberOfEntries() {
        return this.cacheStats.getTotalNumberOfEntries();
    }
}

