/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.math.BigInteger;
import org.infinispan.Cache;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.NumericCommand;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IncrementCommand
extends NumericCommand {
    private static final Log log = LogFactory.getLog(IncrementCommand.class);

    public IncrementCommand(Cache cache, CommandType type, String key, String delta, boolean noReply) {
        super(cache, type, key, delta, noReply);
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitIncrement(ctx, this);
    }

    @Override
    protected BigInteger operate(BigInteger oldValue, BigInteger newValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Increment {0} with {1}", new Object[]{oldValue, newValue});
        }
        return oldValue.add(newValue);
    }
}

