/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import org.infinispan.Cache;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.RetrievalCommand;
import org.infinispan.server.memcached.commands.RetrievalParameters;
import org.infinispan.server.memcached.commands.Value;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class GetCommand
extends RetrievalCommand {
    GetCommand(Cache<String, Value> cache, CommandType type, RetrievalParameters params) {
        super(cache, type, params);
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitGet(ctx, this);
    }

    @Override
    public Object perform(ChannelHandlerContext ctx) throws Throwable {
        Channel ch = ctx.getChannel();
        ChannelBuffers buffers = ctx.getChannelBuffers();
        for (String key : this.params.keys) {
            Value value = (Value)this.cache.get((Object)key);
            if (value == null) continue;
            StringBuilder sb = this.constructValue(key, value);
            ChannelBuffer buffer = buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(sb.toString().getBytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF), buffers.wrappedBuffer(value.getData()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)});
            ch.write((Object)buffer);
        }
        ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(Reply.END.bytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        return Reply.END;
    }

    protected StringBuilder constructValue(String key, Value value) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)Reply.VALUE).append(" ").append(key).append(" ").append(value.getFlags()).append(" ").append(value.getData().length).append(" ");
        return sb;
    }
}

