/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class FlushAllCommand
implements TextCommand {
    final Cache cache;
    final long delay;
    final ScheduledExecutorService scheduler;
    final boolean noReply;

    FlushAllCommand(Cache cache, long delay, ScheduledExecutorService scheduler, boolean noReply) {
        this.cache = cache;
        this.delay = delay;
        this.scheduler = scheduler;
        this.noReply = noReply;
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitFlushAll(ctx, this);
    }

    @Override
    public CommandType getType() {
        return CommandType.FLUSH_ALL;
    }

    @Override
    public Object perform(ChannelHandlerContext ctx) throws Throwable {
        Channel ch = ctx.getChannel();
        if (this.delay == 0L) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_STORE}).clear();
        } else {
            this.scheduler.schedule(new FlushAllDelayed(this.cache), this.delay, TimeUnit.SECONDS);
        }
        if (!this.noReply) {
            ChannelBuffers buffers = ctx.getChannelBuffers();
            ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(Reply.OK.bytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        }
        return Reply.OK;
    }

    public static FlushAllCommand newFlushAllCommand(Cache cache, long delay, ScheduledExecutorService scheduler, boolean noReply) {
        return new FlushAllCommand(cache, delay, scheduler, noReply);
    }

    private static class FlushAllDelayed
    implements Runnable {
        final Cache cache;

        FlushAllDelayed(Cache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_STORE}).clear();
        }
    }
}

