/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import org.infinispan.Cache;
import org.infinispan.server.core.transport.Channel;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.Reply;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.commands.CommandType;
import org.infinispan.server.memcached.commands.TextCommand;
import org.infinispan.server.memcached.interceptors.TextProtocolVisitor;

public class DeleteCommand
implements TextCommand {
    final Cache cache;
    final String key;
    final boolean noReply;

    DeleteCommand(Cache cache, String key, long time, boolean noReply) {
        this.cache = cache;
        this.key = key;
        this.noReply = noReply;
    }

    @Override
    public CommandType getType() {
        return CommandType.DELETE;
    }

    @Override
    public Object acceptVisitor(ChannelHandlerContext ctx, TextProtocolVisitor next) throws Throwable {
        return next.visitDelete(ctx, this);
    }

    @Override
    public Object perform(ChannelHandlerContext ctx) throws Throwable {
        Channel ch = ctx.getChannel();
        Object prev = this.cache.remove((Object)this.key);
        Reply reply = this.reply(prev);
        if (!this.noReply) {
            ChannelBuffers buffers = ctx.getChannelBuffers();
            ch.write((Object)buffers.wrappedBuffer(new ChannelBuffer[]{buffers.wrappedBuffer(reply.bytes()), buffers.wrappedBuffer(TextProtocolUtil.CRLF)}));
        }
        return reply;
    }

    private Reply reply(Object prev) {
        if (prev == null) {
            return Reply.NOT_FOUND;
        }
        return Reply.DELETED;
    }

    public static DeleteCommand newDeleteCommand(Cache cache, String key, boolean noReply) {
        return new DeleteCommand(cache, key, 0L, noReply);
    }
}

