/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.commands;

import java.io.IOException;
import org.infinispan.server.core.UnknownCommandException;

public enum CommandType {
    SET,
    ADD,
    REPLACE,
    APPEND,
    PREPEND,
    CAS,
    GET,
    GETS,
    DELETE,
    INCR,
    DECR,
    STATS,
    FLUSH_ALL,
    VERSION,
    QUIT;


    public boolean isStorage() {
        switch (this) {
            case SET: 
            case ADD: 
            case REPLACE: 
            case APPEND: 
            case PREPEND: 
            case CAS: {
                return true;
            }
        }
        return false;
    }

    static CommandType parseType(String type) throws IOException {
        try {
            return CommandType.valueOf(type.toUpperCase());
        }
        catch (IllegalStateException e) {
            throw new UnknownCommandException("request \"" + type + "\" not known");
        }
    }
}

